/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.validation;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;

public class URIDereferencerImpl
implements URIDereferencer {
    private HashMap<String, ILocator> refTable = new HashMap();

    public void addExternalReference(String uri, ILocator locator) {
        this.refTable.put(uri, locator);
    }

    @Override
    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        ILocator locator = this.getExternalReference(uriReference.getURI());
        if (locator != null) {
            InputStream is = null;
            try {
                is = locator.getInputStream();
                OctetStreamData octetStreamData = new OctetStreamData(is);
                return octetStreamData;
            }
            catch (IOException e) {
                throw new URIReferenceException(e.getLocalizedMessage(), e);
            }
            finally {
                StreamTools.close((Closeable)is);
            }
        }
        return null;
    }

    public ILocator getExternalReference(String uriString) {
        return this.refTable.get(uriString);
    }

    public boolean isEmpty() {
        return this.refTable.isEmpty();
    }
}

