/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.validation;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.validation.BasicSignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.method.xml.signature.X509DataKeySelector;
import de.intarsys.security.method.xml.signature.XMLSignatureContainer;
import de.intarsys.security.method.xml.signature.XMLSignatureEntry;
import de.intarsys.security.signature.CommonSignatureEntryAttributes;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.Info;
import de.intarsys.security.standard.validation.InfoSet;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IInfo;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.digest.IDigest;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.w3c.dom.Node;

public class XMLSignatureEntryValidator
extends BasicSignatureEntryValidator {
    private static final Logger Log = LoggerFactory.getLogger(XMLSignatureEntryValidator.class);
    private DOMValidateContext validateContext;
    private XMLSignature xmlSignature;

    private void addInformationToDigestState(Reference reference, VSDigest digestState) {
        DigestMethod digestMethod = reference.getDigestMethod();
        if (digestMethod != null) {
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithm((String)digestMethod.getAlgorithm());
            digestState.setAlgorithmSpec(new AlgorithmSpec((Algorithm)digestAlgorithm));
        }
        digestState.setReferenceDigest(reference.getDigestValue());
        digestState.setCalculatedDigest(reference.getCalculatedDigestValue());
        InfoSet infoSet = new InfoSet("XML Info");
        infoSet.addInfo((IInfo)new Info("Reference URI", reference.getURI()));
        infoSet.addInfo((IInfo)new Info("Reference Type", reference.getType()));
        digestState.addAdditionalInfoObject((Object)infoSet);
    }

    protected DOMValidateContext createValidateContext(XMLSignatureEntry signatureEntry) {
        DOMValidateContext context = new DOMValidateContext(new X509DataKeySelector(), (Node)signatureEntry.getSignatureElement());
        context.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        XMLSignatureContainer container = signatureEntry.getSignatureContainer();
        context.setBaseURI(container.getBaseURI());
        return context;
    }

    protected XMLSignature createXMLSignature() throws MarshalException {
        return XMLSignatureContainer.getXmlSignatureFactory().unmarshalXMLSignature(this.validateContext);
    }

    public IVSSignatureEntry validate(ISignatureEntry signatureEntry, IDigest digest, IValidationParameters parameters) {
        XMLSignatureEntry xmlSignatureEntry = (XMLSignatureEntry)signatureEntry;
        VSSignatureEntry entryState = new VSSignatureEntry((ISignatureEntry)xmlSignatureEntry);
        this.validateContext = this.createValidateContext(xmlSignatureEntry);
        try {
            this.xmlSignature = this.createXMLSignature();
        }
        catch (MarshalException e) {
            entryState.invalidate(ValidationMessage.createError((String)e.getLocalizedMessage()));
            return entryState;
        }
        VSSignature state = new VSSignature(digest);
        state.setSignatureState(this.verifySignatureValue(xmlSignatureEntry));
        state.addDigestStates(this.verifyReferenceDigests());
        entryState.setSignatureState((IVSSignature)state);
        return entryState;
    }

    private VSDigest verifyReferenceDigest(Reference reference) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("validating reference with uri='" + reference.getURI() + "'");
        }
        VSDigest digestState = new VSDigest();
        try {
            if (reference.validate(this.validateContext)) {
                digestState.increaseState(0);
            } else {
                digestState.increaseState(3);
            }
        }
        catch (XMLSignatureException e) {
            digestState.invalidate(ValidationMessage.createError((String)e.getLocalizedMessage()));
        }
        return digestState;
    }

    private IVSDigest[] verifyReferenceDigests() {
        List<Reference> references = this.xmlSignature.getSignedInfo().getReferences();
        ArrayList<VSDigest> result = new ArrayList<VSDigest>(references.size());
        for (Reference reference : references) {
            VSDigest digestState = this.verifyReferenceDigest(reference);
            this.addInformationToDigestState(reference, digestState);
            result.add(digestState);
        }
        return result.toArray(new IVSDigest[result.size()]);
    }

    private IVSMathematicalSignature verifySignatureValue(XMLSignatureEntry xmlSignatureEntry) {
        VSMathematicalSignature pkcs1State = null;
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("validating signature with id='" + this.xmlSignature.getId() + "'");
        }
        XMLSignature.SignatureValue signatureValue = this.xmlSignature.getSignatureValue();
        try {
            pkcs1State = signatureValue.validate(this.validateContext) ? new VSMathematicalSignature(0) : new VSMathematicalSignature(3);
        }
        catch (XMLSignatureException e) {
            pkcs1State = new VSMathematicalSignature(3);
            pkcs1State.addMessage(ValidationMessage.createError((String)e.getLocalizedMessage()));
        }
        pkcs1State.setSignature(signatureValue.getValue());
        pkcs1State.setSignatureAlgorithmSpec(xmlSignatureEntry.getSignatureAlgorithmSpec());
        pkcs1State.setHashAlgorithmSpec(xmlSignatureEntry.getHashAlgorithmSpec());
        InfoSet infoSet = new InfoSet("XML Info");
        infoSet.addInfo((IInfo)new Info("Signature Id", this.xmlSignature.getId()));
        CommonSignatureEntryAttributes.setXMLSignatureValueId((ISignatureEntry)xmlSignatureEntry, (String)this.xmlSignature.getId());
        infoSet.addInfo((IInfo)new Info("Signature XPath", xmlSignatureEntry.getXPathToSignatureNode()));
        CommonSignatureEntryAttributes.setXMLSignatureElementXPath((ISignatureEntry)xmlSignatureEntry, (String)xmlSignatureEntry.getXPathToSignatureNode());
        pkcs1State.addAdditionalInfoObject((Object)infoSet);
        return pkcs1State;
    }
}

