/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.validation;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonValidationDataExtender;
import de.intarsys.security.app.validation.common.EntryStateValidationDataCollector;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.method.xml.attribute.encoder.CertificateValuesEncoder;
import de.intarsys.security.method.xml.attribute.encoder.RevocationValuesEncoder;
import de.intarsys.security.method.xml.attribute.encoder.TimeStampValidationDataEncoder;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignatureEntry;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IValidationState;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Element;

public class XMLValidationDataExtender
extends CommonValidationDataExtender<XMLSignatureEntry> {
    private static final Object OBJ_VALIDATION_DATA = new Object();
    private static final Object OBJ_SIGNATURE_ENTRY = new Object();

    public static IExtendedValidationData getExtendedValidationData(XMLCryptoContext context) {
        return (IExtendedValidationData)context.get(OBJ_VALIDATION_DATA);
    }

    public static XMLSignatureEntry getSignatureEntry(XMLCryptoContext context) {
        return (XMLSignatureEntry)context.get(OBJ_SIGNATURE_ENTRY);
    }

    public static void putExtendedValidationData(XMLCryptoContext context, IExtendedValidationData validationData) {
        context.put(OBJ_VALIDATION_DATA, validationData);
    }

    public static void putSignatureEntry(XMLCryptoContext context, XMLSignatureEntry entry) {
        context.put(OBJ_SIGNATURE_ENTRY, entry);
    }

    protected XMLCryptoContext createCryptoContext() {
        DOMCryptoContext context = new DOMCryptoContext(){};
        return context;
    }

    public void extend(IVSSignatureContainerEntry entryState) throws GeneralSecurityException, IOException {
        XMLCryptoContext context = this.createCryptoContext();
        XMLSignatureEntry entry = (XMLSignatureEntry)entryState.getEntry();
        this.extend(context, entry, (IValidationState)entryState);
    }

    protected void extend(XMLCryptoContext context, Supplier<Element> parentSupplier, CertificateValuesEncoder provider) throws MarshalException {
        provider.marshal(null, context, parentSupplier);
    }

    protected void extend(XMLCryptoContext context, Supplier<Element> parentSupplier, RevocationValuesEncoder provider) throws MarshalException {
        provider.marshal(null, context, parentSupplier);
    }

    protected void extend(XMLCryptoContext context, Supplier<Element> parentSupplier, TimeStampValidationDataEncoder provider) throws MarshalException {
        provider.marshal(null, context, parentSupplier);
    }

    protected void extend(XMLCryptoContext context, XMLSignatureEntry entry, IValidationState entryState) throws IOException {
        XMLValidationDataExtender.putSignatureEntry(context, entry);
        Supplier<Element> qualifyingPropertiesSupplier = XAdESBaseline.getQualifyingPropertiesSupplier(entry::getSignatureElement);
        Supplier<Element> unsignedPropertiesSupplier = XAdESBaseline.getUnsignedPropertiesSupplier(qualifyingPropertiesSupplier, null);
        Supplier<Element> unsignedSignaturePropertiesSupplier = XAdESBaseline.getUnsignedSignaturePropertiesSupplier(unsignedPropertiesSupplier, null);
        try {
            EntryStateValidationDataCollector collectorSignature = new EntryStateValidationDataCollector(entryState);
            collectorSignature.setValidationDataOptions(this.getValidationDataOptions());
            collectorSignature.setCollectSignatureData(true);
            collectorSignature.setCollectTimestampData(false);
            this.extendSignatureData(context, collectorSignature.collect(), unsignedSignaturePropertiesSupplier);
            EntryStateValidationDataCollector collectorTimestamp = new EntryStateValidationDataCollector(entryState);
            collectorTimestamp.setValidationDataOptions(this.getValidationDataOptions());
            collectorTimestamp.setCollectSignatureData(false);
            collectorTimestamp.setCollectTimestampData(true);
            this.extendTimestampData(context, collectorTimestamp.collect(), unsignedSignaturePropertiesSupplier);
        }
        catch (MarshalException e) {
            throw new IOException(e);
        }
    }

    protected void extend(XMLSignatureEntry entry, IExtendedValidationData validationData) throws IOException {
    }

    protected void extendSignatureData(XMLCryptoContext context, IExtendedValidationData validationData, Supplier<Element> supplier) throws IOException, MarshalException {
        XMLValidationDataExtender.putExtendedValidationData(context, validationData);
        this.extend(context, supplier, new CertificateValuesEncoder());
        this.extend(context, supplier, new RevocationValuesEncoder());
    }

    protected void extendTimestampData(XMLCryptoContext context, IExtendedValidationData validationData, Supplier<Element> supplier) throws IOException, MarshalException {
        XMLValidationDataExtender.putExtendedValidationData(context, validationData);
        this.extend(context, supplier, new TimeStampValidationDataEncoder());
    }

    public void process(ISignatureContainerBuilder builder, XMLSignatureEntry entry, ISignatureData signatureData) throws SecurityApplicationException, IOException {
        IValidationState entryState = this.validate((ISignatureContainerEntry)entry);
        XMLCryptoContext context = ((IXMLSignatureContainerBuilder)builder).getCryptoContext();
        this.extend(context, entry, entryState);
    }
}

