/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.security.KeyException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyInfoFactory;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.apache.jcp.xml.dsig.internal.dom.ISKeyInfo;
import org.apache.jcp.xml.dsig.internal.dom.ISKeyValue;
import org.apache.jcp.xml.dsig.internal.dom.KeyInfoFactoryProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ISKeyInfoFactory
extends KeyInfoFactoryProxy {
    public ISKeyInfoFactory() {
        super((KeyInfoFactory)new DOMKeyInfoFactory());
    }

    @Override
    public KeyInfo newKeyInfo(List content) {
        return this.newKeyInfo(content, (String)null);
    }

    @Override
    public KeyInfo newKeyInfo(List content, String id) {
        return new ISKeyInfo(content, id);
    }

    @Override
    public KeyValue newKeyValue(PublicKey key) throws KeyException {
        String algorithm = key.getAlgorithm();
        if (algorithm.equals("DSA")) {
            return new DOMKeyValue.DSA((DSAPublicKey)key);
        }
        if (algorithm.equals("RSA")) {
            return new DOMKeyValue.RSA((RSAPublicKey)key);
        }
        if (algorithm.equals("EC")) {
            return new ISKeyValue.EC_XMLDSIG11((ECPublicKey)key);
        }
        return super.newKeyValue(key);
    }

    @Override
    public KeyInfo unmarshalKeyInfo(XMLStructure xmlStructure) throws MarshalException {
        if (xmlStructure == null) {
            throw new NullPointerException("xmlStructure cannot be null");
        }
        if (!(xmlStructure instanceof DOMStructure)) {
            throw new ClassCastException("xmlStructure must be of type DOMStructure");
        }
        Node node = ((DOMStructure)xmlStructure).getNode();
        node.normalize();
        Element element = null;
        if (node.getNodeType() == 9) {
            element = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 1) {
            element = (Element)node;
        } else {
            throw new MarshalException("xmlStructure does not contain a proper Node");
        }
        String tag = element.getLocalName();
        if (tag == null) {
            throw new MarshalException("Document implementation must support DOM Level 2 and be namespace aware");
        }
        if (tag.equals("KeyInfo")) {
            return new ISKeyInfo(element, new UnmarshalContext(), this.getProvider());
        }
        throw new MarshalException("invalid KeyInfo tag: " + tag);
    }

    private static class UnmarshalContext
    extends DOMCryptoContext {
        UnmarshalContext() {
        }
    }
}

