/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.oid.OIDTools;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ISKeyValue<T extends PublicKey>
extends DOMKeyValue<T> {
    private static final String XMLDSIG_11_XMLNS = "http://www.w3.org/2009/xmldsig11#";
    private static final String RFC_4050_XMLNS = "http://www.w3.org/2001/04/xmldsig-more#";
    private static final String RFC_4050_XMLNS_PREFIX = "ecdsa";

    private static PublicKey generatePublicKey(KeyFactory kf, KeySpec keyspec) {
        try {
            return kf.generatePublic(keyspec);
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
    }

    static KeyValue unmarshal(Element kvElem) throws MarshalException {
        Element kvtElem = DOMUtils.getFirstChildElement((Node)kvElem);
        if (kvtElem.getLocalName().equals("DSAKeyValue")) {
            return new DOMKeyValue.DSA(kvtElem);
        }
        if (kvtElem.getLocalName().equals("RSAKeyValue")) {
            return new DOMKeyValue.RSA(kvtElem);
        }
        if (kvtElem.getLocalName().equals("ECKeyValue")) {
            return new EC_XMLDSIG11(kvtElem);
        }
        if (kvtElem.getLocalName().equals("ECDSAKeyValue")) {
            return new EC_RFC4050(kvtElem);
        }
        return new DOMKeyValue.Unknown(kvtElem);
    }

    public ISKeyValue(Element kvtElem) throws MarshalException {
        super(kvtElem);
    }

    public ISKeyValue(T key) throws KeyException {
        super(key);
    }

    static final class EC_XMLDSIG11
    extends CommonECKeyValue {
        protected byte[] ecPublicKey;

        EC_XMLDSIG11(ECPublicKey key) throws KeyException {
            super(key);
            this.ecPublicKey = EcTools.encodeECPointX9Uncompressed((EllipticCurve)this.ecParams.getCurve(), (ECPoint)this.ecPoint);
        }

        EC_XMLDSIG11(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        void marshalPublicKey(XmlWriter xwriter, ECPublicKey key, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            String prefix = DOMUtils.getNSPrefix((XMLCryptoContext)context, (String)ISKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeStartElement(prefix, "ECKeyValue", ISKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeStartElement(prefix, "NamedCurve", ISKeyValue.XMLDSIG_11_XMLNS);
            xwriter.writeNamespace(prefix, ISKeyValue.XMLDSIG_11_XMLNS);
            String oid = this.getCurveOID();
            xwriter.writeAttribute("", "", "URI", "urn:oid:" + oid);
            xwriter.writeEndElement();
            xwriter.writeStartElement(prefix, "PublicKey", ISKeyValue.XMLDSIG_11_XMLNS);
            String encoded = Base64.encode((byte[])this.ecPublicKey);
            xwriter.writeCharacters(encoded);
            xwriter.writeEndElement();
            xwriter.writeEndElement();
        }

        ECPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException {
            ECPoint ecPoint;
            String uri;
            ECParameterSpec ecParams = null;
            Element curElem = DOMUtils.getFirstChildElement((Node)kvtElem);
            if (curElem.getLocalName().equals("ECParameters")) {
                throw new UnsupportedOperationException("ECParameters not supported");
            }
            if (curElem.getLocalName().equals("NamedCurve")) {
                uri = DOMUtils.getAttributeValue((Element)curElem, (String)"URI");
                if (!uri.startsWith("urn:oid:")) {
                    throw new MarshalException("Invalid NamedCurve URI");
                }
            } else {
                throw new MarshalException("Invalid ECKeyValue");
            }
            String oid = uri.substring(8);
            ecParams = this.createECParameterSpec(oid);
            curElem = DOMUtils.getNextSiblingElement((Node)curElem, (String)"PublicKey");
            try {
                ecPoint = EcTools.decodeECPointX9Uncompressed((byte[])Base64.decode((Element)curElem));
            }
            catch (Base64DecodingException e) {
                throw new MarshalException(e);
            }
            ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, ecParams);
            return (ECPublicKey)ISKeyValue.generatePublicKey(this.getKeyFactory(), spec);
        }
    }

    static final class EC_RFC4050
    extends CommonECKeyValue {
        EC_RFC4050(ECPublicKey key) throws KeyException {
            super(key);
        }

        EC_RFC4050(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        void marshalPublicKey(XmlWriter xwriter, ECPublicKey key, String dsPrefix, XMLCryptoContext context) throws MarshalException {
            String prefix = DOMUtils.getNSPrefix((XMLCryptoContext)context, (String)ISKeyValue.RFC_4050_XMLNS);
            String xmlnsXSI = "http://www.w3.org/2001/XMLSchema-instance";
            String prefixXSI = DOMUtils.getNSPrefix((XMLCryptoContext)context, (String)xmlnsXSI);
            if (prefix == null) {
                prefix = ISKeyValue.RFC_4050_XMLNS_PREFIX;
            }
            if (prefixXSI == null) {
                prefixXSI = "xsi";
            }
            xwriter.writeStartElement(prefix, "ECDSAKeyValue", ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeNamespace(prefix, ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeNamespace(prefixXSI, xmlnsXSI);
            xwriter.writeStartElement(prefix, "DomainParameters", ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeStartElement(prefix, "NamedCurve", ISKeyValue.RFC_4050_XMLNS);
            String oid = this.getCurveOID();
            xwriter.writeAttribute("", "", "URN", "urn:oid:" + oid);
            xwriter.writeEndElement();
            xwriter.writeEndElement();
            xwriter.writeStartElement(prefix, "PublicKey", ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeStartElement(prefix, "X", ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeAttribute(prefixXSI, xmlnsXSI, "type", prefix + ":PrimeFieldElemType");
            xwriter.writeAttribute("", "", "Value", this.ecPoint.getAffineX().toString());
            xwriter.writeEndElement();
            xwriter.writeStartElement(prefix, "Y", ISKeyValue.RFC_4050_XMLNS);
            xwriter.writeAttribute(prefixXSI, xmlnsXSI, "type", prefix + ":PrimeFieldElemType");
            xwriter.writeAttribute("", "", "Value", this.ecPoint.getAffineY().toString());
            xwriter.writeEndElement();
            xwriter.writeEndElement();
            xwriter.writeEndElement();
        }

        ECPublicKey unmarshalKeyValue(Element kvtElem) throws MarshalException {
            String uri;
            ECParameterSpec ecParams = null;
            Element domainParametersElem = DOMUtils.getFirstChildElement((Node)kvtElem);
            Element publicKeyElem = DOMUtils.getNextSiblingElement((Node)domainParametersElem, (String)"PublicKey");
            Element curElem = DOMUtils.getFirstChildElement((Node)domainParametersElem);
            if (curElem.getLocalName().equals("ExplicitParameters")) {
                throw new UnsupportedOperationException("ExplicitParameters not supported");
            }
            if (curElem.getLocalName().equals("NamedCurve")) {
                uri = DOMUtils.getAttributeValue((Element)curElem, (String)"URN");
                if (!uri.startsWith("urn:oid:")) {
                    throw new MarshalException("Invalid NamedCurve URI");
                }
            } else {
                throw new MarshalException("Invalid ECKeyValue");
            }
            String oid = uri.substring(8);
            ecParams = this.createECParameterSpec(oid);
            Element xElem = DOMUtils.getFirstChildElement((Node)publicKeyElem, (String)"X");
            Element yElem = DOMUtils.getNextSiblingElement((Node)xElem, (String)"Y");
            String x = DOMUtils.getAttributeValue((Element)xElem, (String)"Value");
            String y = DOMUtils.getAttributeValue((Element)yElem, (String)"Value");
            ECPoint ecPoint = new ECPoint(new BigInteger(x), new BigInteger(y));
            ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, ecParams);
            return (ECPublicKey)ISKeyValue.generatePublicKey(this.getKeyFactory(), spec);
        }
    }

    static abstract class CommonECKeyValue
    extends ISKeyValue<ECPublicKey> {
        protected ECPoint ecPoint;
        private KeyFactory eckf;
        protected ECParameterSpec ecParams;

        protected CommonECKeyValue(ECPublicKey ecKey) throws KeyException {
            super(ecKey);
            this.ecPoint = ecKey.getW();
            this.ecParams = ecKey.getParams();
        }

        protected CommonECKeyValue(Element dmElem) throws MarshalException {
            super(dmElem);
        }

        protected ECParameterSpec createECParameterSpec(String curveOid) {
            String name = OIDTools.getECCurveName((String)curveOid);
            ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)name);
            ECParameterSpec ecParams = EC5Util.convertSpec((EllipticCurve)EC5Util.convertCurve((ECCurve)parameterSpec.getCurve(), (byte[])parameterSpec.getSeed()), (org.bouncycastle.jce.spec.ECParameterSpec)parameterSpec);
            return ecParams;
        }

        protected String getCurveOID() throws MarshalException {
            if (this.ecParams instanceof ECNamedCurveSpec) {
                ECNamedCurveSpec ecNamedCurveSpec = (ECNamedCurveSpec)this.ecParams;
                String curveName = ecNamedCurveSpec.getName();
                String oid = OIDTools.getECCurveOID((String)curveName);
                if (oid == null) {
                    throw new MarshalException("Unsupported curve: " + curveName);
                }
                return oid;
            }
            if (ECNamedCurveSpec.class.getName().equals(this.ecParams.getClass().getName())) {
                throw new MarshalException("Classloader Error: BouncyCastle Provider was registered and loaded in an other web context. If BC is shared between web applications, please add BC to a shared location like <tomcat>/lib.");
            }
            throw new MarshalException("Only named curves supported.");
        }

        protected KeyFactory getKeyFactory() {
            if (this.eckf == null) {
                try {
                    this.eckf = KeyFactory.getInstance("EC");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("unable to create EC KeyFactory: " + e.getMessage());
                }
            }
            return this.eckf;
        }
    }
}

