/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries;

import de.intarsys.pentablet.timeseries.ChannelType;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;

public class ChannelData<Q extends Quantity<Q>> {
    private boolean constant;
    private int[] data = new int[100];
    private int declaredMax;
    private int declaredMin;
    private int effectiveMax = -1;
    private int effectiveMin = -1;
    private Number scale;
    private int size = 0;
    private ChannelType<Q> type;
    private Unit<Q> unit;

    public ChannelData(ChannelType<Q> type) {
        this(type, -1, -1, 1, null);
    }

    public ChannelData(ChannelType<Q> type, int min, int max) {
        this(type, min, max, 1, null);
    }

    public ChannelData(ChannelType<Q> type, int min, int max, Number scale, Unit<Q> unit) {
        this(type, min, max, scale, unit, false);
    }

    public ChannelData(ChannelType<Q> type, int min, int max, Number scale, Unit<Q> unit, boolean constant) {
        Objects.requireNonNull(scale);
        this.type = type;
        this.declaredMin = min;
        this.declaredMax = max;
        this.scale = scale;
        this.unit = unit;
        this.constant = constant;
    }

    public ChannelData(ChannelType<Q> type, Number scale, Unit<Q> unit) {
        this(type, -1, -1, scale, unit);
    }

    public void add(int value) {
        if (this.data.length == this.size) {
            this.data = Arrays.copyOf(this.data, this.data.length + 50);
        }
        this.data[this.size] = value;
        if (this.size == 0) {
            this.effectiveMin = this.effectiveMax = value;
        } else {
            this.effectiveMin = Math.min(this.effectiveMin, value);
            this.effectiveMax = Math.max(this.effectiveMax, value);
        }
        ++this.size;
    }

    public int get(int index) {
        return this.data[index];
    }

    public int getDeclaredMax() {
        return this.declaredMax;
    }

    public int getDeclaredMin() {
        return this.declaredMin;
    }

    public int getEffectiveMax() {
        return this.effectiveMax;
    }

    public int getEffectiveMin() {
        return this.effectiveMin;
    }

    public Number getScale() {
        return this.scale;
    }

    public ChannelType<?> getType() {
        return this.type;
    }

    public Unit<Q> getUnit() {
        if (this.unit == null) {
            return this.type.getUnits();
        }
        return this.unit;
    }

    public boolean hasMax() {
        return this.declaredMax != -1;
    }

    public boolean hasMin() {
        return this.declaredMin != -1;
    }

    public boolean hasScale() {
        Number normalizedScale = this.unit == null ? (Number)this.scale : (Number)this.type.getNormalizedScale(this.scale, this.getUnit());
        return normalizedScale.doubleValue() != 1.0;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public int size() {
        return this.size;
    }
}

