/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries;

import de.intarsys.pentablet.timeseries.ForceChannel;
import de.intarsys.pentablet.timeseries.OrientationChannel;
import de.intarsys.pentablet.timeseries.PositionChannel;
import de.intarsys.pentablet.timeseries.Representation;
import de.intarsys.pentablet.timeseries.TimeChannel;
import de.intarsys.pentablet.timeseries.UnspecifiedChannel;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;

public abstract class ChannelType<Q extends Quantity<Q>>
implements Comparable<ChannelType<?>> {
    public static OrientationChannel A = new OrientationChannel("A", 2, false);
    public static UnspecifiedChannel AX = new UnspecifiedChannel("AX", 10, true);
    public static UnspecifiedChannel AY = new UnspecifiedChannel("AY", 9, true);
    public static UnspecifiedChannel DT = new UnspecifiedChannel("DT", 7, false);
    public static OrientationChannel E = new OrientationChannel("E", 1, false);
    public static ForceChannel F = new ForceChannel("F", 6, false);
    public static OrientationChannel R = new OrientationChannel("R", 0, false);
    public static UnspecifiedChannel S = new UnspecifiedChannel("S", 5, false);
    public static TimeChannel T = new TimeChannel("T", 8);
    public static UnspecifiedChannel TX = new UnspecifiedChannel("TX", 4, true);
    public static UnspecifiedChannel TY = new UnspecifiedChannel("TY", 3, true);
    public static UnspecifiedChannel VX = new UnspecifiedChannel("VX", 12, true);
    public static UnspecifiedChannel VY = new UnspecifiedChannel("VY", 11, true);
    public static PositionChannel X = new PositionChannel("X", 15, true);
    public static PositionChannel Y = new PositionChannel("Y", 14, true);
    public static PositionChannel Z = new PositionChannel("Z", 13, false);
    public static ChannelType<?>[] ALL = new ChannelType[]{X, Y, Z, VX, VY, AX, AY, T, DT, F, S, TX, TY, A, E, R};
    private int inclusionBit;
    private String name;
    private boolean signed;

    public ChannelType(String name, int inclusionBit, boolean signed) {
        this.name = name;
        this.inclusionBit = inclusionBit;
        this.signed = signed;
    }

    @Override
    public int compareTo(ChannelType<?> other) {
        return Integer.compare(15 - this.inclusionBit, 15 - other.inclusionBit);
    }

    public int getDecoded(int value) {
        if (this.signed) {
            return value - 32768;
        }
        return value;
    }

    public int getEncoded(int value) {
        if (this.signed) {
            return value - 32768;
        }
        return value;
    }

    public int getEncodedMax(Representation representation) {
        return this.getEncoded(representation.getDeclaredMax(this));
    }

    public int getEncodedMin(Representation representation) {
        return this.getEncoded(representation.getDeclaredMin(this));
    }

    public int getInclusionBit() {
        return this.inclusionBit;
    }

    public String getName() {
        return this.name;
    }

    public int getNormalizedEncodedValue(Representation representation, int index) {
        return this.getEncoded(this.getNormalizedValue(representation, index));
    }

    public Number getNormalizedScale(Number scale, Unit<Q> unit) {
        if (unit == null) {
            return scale;
        }
        UnitConverter converter = this.getUnits().getConverterTo(unit);
        return converter.convert(scale).doubleValue();
    }

    public int getNormalizedValue(Representation representation, int index) {
        return representation.get(this, index);
    }

    public abstract Unit<Q> getUnits();
}

