/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries;

import de.intarsys.pentablet.timeseries.ChannelData;
import de.intarsys.pentablet.timeseries.ChannelType;
import de.intarsys.pentablet.timeseries.ISamplePointCollection;
import de.intarsys.pentablet.timeseries.RepresentationViewSamplePoint;
import de.intarsys.pentablet.timeseries.SamplePoint;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.measure.Quantity;
import javax.measure.Unit;

public class Representation
implements IAttributeSupport,
ISamplePointCollection {
    private IAttributeSupport attributes = new AttributeMap();
    private SortedSet<ChannelType<?>> cachedChannelTypes = new TreeSet();
    protected Temporal captureDateAndTime;
    private int captureDeviceTechnology;
    private ChannelData<?>[] channels = new ChannelData[16];

    public Representation(int captureDeviceTechnology, Set<ChannelData<?>> channels) {
        this(captureDeviceTechnology, channels, LocalDateTime.now(ZoneOffset.UTC));
    }

    public Representation(int captureDeviceTechnology, Set<ChannelData<?>> channels, Temporal captureDateAndTime) {
        this.captureDeviceTechnology = captureDeviceTechnology;
        channels.stream().forEach(channel -> {
            ChannelType<?> channelType = channel.getType();
            this.channels[channelType.getInclusionBit()] = channel;
            this.cachedChannelTypes.add(channelType);
        });
        this.captureDateAndTime = captureDateAndTime;
    }

    public void add(SamplePoint samplePoint) {
        for (int index = 0; index < 16; ++index) {
            ChannelData<?> channel = this.channels[index];
            if (channel == null) continue;
            channel.add(samplePoint.get(channel.getType()));
        }
    }

    public int get(ChannelType<?> channelType, int index) {
        return this.channels[channelType.getInclusionBit()].get(index);
    }

    @Override
    public SamplePoint get(int index) {
        return new RepresentationViewSamplePoint(this.channels, index);
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public Temporal getCaptureDateAndTime() {
        return this.captureDateAndTime;
    }

    public int getCaptureDeviceTechnology() {
        return this.captureDeviceTechnology;
    }

    public SortedSet<ChannelType<?>> getChannelTypes() {
        return this.cachedChannelTypes;
    }

    public int getDeclaredMax(ChannelType<?> channelType) {
        return this.channels[channelType.getInclusionBit()].getDeclaredMax();
    }

    public int getDeclaredMin(ChannelType<?> channelType) {
        return this.channels[channelType.getInclusionBit()].getDeclaredMin();
    }

    @Override
    public double getF(int index) {
        return this.get(ChannelType.F, index);
    }

    @Override
    public double getMaxF() {
        return this.channels[ChannelType.F.getInclusionBit()].getEffectiveMax();
    }

    @Override
    public double getMaxX() {
        return this.channels[ChannelType.X.getInclusionBit()].getEffectiveMax();
    }

    @Override
    public double getMaxY() {
        return this.channels[ChannelType.Y.getInclusionBit()].getEffectiveMax();
    }

    @Override
    public double getMinF() {
        return this.channels[ChannelType.F.getInclusionBit()].getEffectiveMin();
    }

    @Override
    public double getMinX() {
        return this.channels[ChannelType.X.getInclusionBit()].getEffectiveMin();
    }

    @Override
    public double getMinY() {
        return this.channels[ChannelType.Y.getInclusionBit()].getEffectiveMin();
    }

    public Number getScale(ChannelType<?> channelType) {
        return this.channels[channelType.getInclusionBit()].getScale();
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(ChannelType<Q> channelType) {
        ChannelData<?> channelData = this.channels[channelType.getInclusionBit()];
        return channelData.getUnit();
    }

    @Override
    public double getX(int index) {
        return this.get(ChannelType.X, index);
    }

    @Override
    public double getY(int index) {
        return this.get(ChannelType.Y, index);
    }

    public boolean hasMax(ChannelType<?> channelType) {
        ChannelData<?> channel = this.channels[channelType.getInclusionBit()];
        if (channel == null) {
            return false;
        }
        return channel.hasMax();
    }

    public boolean hasMin(ChannelType<?> channelType) {
        ChannelData<?> channel = this.channels[channelType.getInclusionBit()];
        if (channel == null) {
            return false;
        }
        return channel.hasMin();
    }

    public boolean hasScale(ChannelType<?> channelType) {
        ChannelData<?> channel = this.channels[channelType.getInclusionBit()];
        if (channel == null) {
            return false;
        }
        return channel.hasScale();
    }

    public boolean isConstant(ChannelType<?> channelType) {
        return this.channels[channelType.getInclusionBit()].isConstant();
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    @Override
    public int size() {
        for (int index = 0; index < 16; ++index) {
            ChannelData<?> channel = this.channels[index];
            if (channel == null) continue;
            return channel.size();
        }
        return 0;
    }
}

