/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries.serialize;

import de.intarsys.pentablet.timeseries.ChannelType;
import de.intarsys.pentablet.timeseries.Representation;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import javax.measure.Quantity;

public class RepresentationBdbSerializer {
    private boolean closed = false;
    private DataOutputStream dataOutputStream;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public RepresentationBdbSerializer() {
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    public byte[] serializeRepresentation(Representation representation) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        try {
            this.writeRepresentationLengthPlaceholder();
            this.writeCaptureDateAndTime(representation);
            this.writeCaptureDeviceTechnologyIdentifier(representation);
            this.writeCaptureDeviceVendorIdentifier();
            this.writeCaptureDeviceTypeIdentifier();
            this.writeQualityRecord();
            this.writeChannelDescriptions(representation);
            this.writeNumberOfSamplePoints(representation);
            this.writeSamplePoints(representation);
            this.writeExtendedDataLength();
        }
        finally {
            this.closed = true;
            this.dataOutputStream.close();
        }
        byte[] bytes = this.outputStream.toByteArray();
        bytes[0] = (byte)(bytes.length >>> 24 & 0xFF);
        bytes[1] = (byte)(bytes.length >>> 16 & 0xFF);
        bytes[2] = (byte)(bytes.length >>> 8 & 0xFF);
        bytes[3] = (byte)(bytes.length >>> 0 & 0xFF);
        return bytes;
    }

    protected void writeCaptureDateAndTime(Representation representation) throws IOException {
        Temporal captureDateAndTime = representation.getCaptureDateAndTime();
        this.dataOutputStream.writeShort(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.YEAR) ? captureDateAndTime.get(ChronoField.YEAR) : -1);
        this.dataOutputStream.writeByte(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.MONTH_OF_YEAR) ? captureDateAndTime.get(ChronoField.MONTH_OF_YEAR) : -1);
        this.dataOutputStream.writeByte(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.DAY_OF_MONTH) ? captureDateAndTime.get(ChronoField.DAY_OF_MONTH) : -1);
        this.dataOutputStream.writeByte(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.HOUR_OF_DAY) ? captureDateAndTime.get(ChronoField.HOUR_OF_DAY) : -1);
        this.dataOutputStream.writeByte(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.MINUTE_OF_HOUR) ? captureDateAndTime.get(ChronoField.MINUTE_OF_HOUR) : -1);
        this.dataOutputStream.writeByte(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.SECOND_OF_MINUTE) ? captureDateAndTime.get(ChronoField.SECOND_OF_MINUTE) : -1);
        this.dataOutputStream.writeShort(captureDateAndTime != null && captureDateAndTime.isSupported(ChronoField.MILLI_OF_SECOND) ? captureDateAndTime.get(ChronoField.MILLI_OF_SECOND) : -1);
    }

    protected void writeCaptureDeviceTechnologyIdentifier(Representation representation) throws IOException {
        this.dataOutputStream.writeByte(representation.getCaptureDeviceTechnology());
    }

    protected void writeCaptureDeviceTypeIdentifier() throws IOException {
        this.dataOutputStream.writeShort(0);
    }

    protected void writeCaptureDeviceVendorIdentifier() throws IOException {
        this.dataOutputStream.writeShort(0);
    }

    protected void writeChannelDescription(Representation representation, ChannelType<?> channelType) throws IOException {
        this.writeChannelDescriptionPreamble(representation, channelType);
        this.writeScalingValue(representation, channelType);
        this.writeMinimumPossibleValue(representation, channelType);
        this.writeMaximumPossibleValue(representation, channelType);
    }

    protected void writeChannelDescriptionPreamble(Representation representation, ChannelType<?> channelType) throws IOException {
        int channelDescriptionPreamble = 0;
        if (representation.hasScale(channelType)) {
            channelDescriptionPreamble |= 0x80;
        }
        if (representation.hasMin(channelType)) {
            channelDescriptionPreamble |= 0x40;
        }
        if (representation.hasMax(channelType)) {
            channelDescriptionPreamble |= 0x20;
        }
        if (representation.isConstant(channelType)) {
            channelDescriptionPreamble |= 4;
        }
        this.dataOutputStream.writeByte(channelDescriptionPreamble);
    }

    protected void writeChannelDescriptions(Representation representation) throws IOException {
        this.writeChannelInclusionField(representation);
        for (ChannelType channelType : representation.getChannelTypes()) {
            this.writeChannelDescription(representation, channelType);
        }
    }

    protected void writeChannelInclusionField(Representation representation) throws IOException {
        int channelInclusionField = 0;
        for (ChannelType channelType : representation.getChannelTypes()) {
            channelInclusionField |= 1 << channelType.getInclusionBit();
        }
        this.dataOutputStream.writeShort(channelInclusionField);
    }

    protected void writeExtendedDataLength() throws IOException {
        this.dataOutputStream.writeShort(0);
    }

    protected void writeMaximumPossibleValue(Representation representation, ChannelType<?> channelType) throws IOException {
        if (!representation.hasMax(channelType)) {
            return;
        }
        this.dataOutputStream.writeShort(channelType.getEncodedMax(representation));
    }

    protected void writeMinimumPossibleValue(Representation representation, ChannelType<?> channelType) throws IOException {
        if (!representation.hasMin(channelType)) {
            return;
        }
        this.dataOutputStream.writeShort(channelType.getEncodedMin(representation));
    }

    protected void writeNumberOfSamplePoints(Representation representation) throws IOException {
        int size = representation.size();
        this.dataOutputStream.writeByte(size >>> 16 & 0xFF);
        this.dataOutputStream.writeByte(size >>> 8 & 0xFF);
        this.dataOutputStream.writeByte(size >>> 0 & 0xFF);
    }

    protected void writeQualityRecord() throws IOException {
        this.dataOutputStream.writeByte(0);
    }

    protected void writeRepresentationLengthPlaceholder() throws IOException {
        this.dataOutputStream.writeInt(0);
    }

    protected void writeSamplePoints(Representation representation) throws IOException {
        for (int index = 0; index < representation.size(); ++index) {
            for (ChannelType channelType : representation.getChannelTypes()) {
                if (representation.isConstant(channelType)) continue;
                this.dataOutputStream.writeShort(channelType.getNormalizedEncodedValue(representation, index));
            }
        }
    }

    protected <Q extends Quantity<Q>> void writeScalingValue(Representation representation, ChannelType<Q> channelType) throws IOException {
        if (!representation.hasScale(channelType)) {
            return;
        }
        double converted = channelType.getNormalizedScale(representation.getScale(channelType), representation.getUnit(channelType)).doubleValue();
        int unbiasedExponent = Math.getExponent(converted);
        int significand = (int)((converted / Math.pow(2.0, unbiasedExponent) - 1.0) * 2048.0);
        int scalingValue = unbiasedExponent + 16 << 11 | significand;
        this.dataOutputStream.writeShort(scalingValue);
    }
}

