/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries.serialize;

import de.intarsys.pentablet.timeseries.ChannelData;
import de.intarsys.pentablet.timeseries.ChannelType;
import de.intarsys.pentablet.timeseries.Representation;
import de.intarsys.pentablet.timeseries.SignatureTimeSeries;
import de.intarsys.pentablet.timeseries.WritableSamplePoint;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SignatureTimeSeriesBdbDeserializer {
    private boolean closed = false;
    private DataInputStream dataInputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureTimeSeries deserializeTimeSeries(byte[] bytes) throws IOException {
        List<Representation> representations;
        if (this.closed) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        this.dataInputStream = new DataInputStream(inputStream);
        try {
            this.dataInputStream.skipBytes(12);
            int numberOfRepresentations = this.readNumberOfRepresentations();
            this.dataInputStream.skipBytes(1);
            representations = this.readRepresentations(numberOfRepresentations);
            if (inputStream.available() != 0) {
                throw new IllegalArgumentException();
            }
        }
        finally {
            this.closed = true;
            this.dataInputStream.close();
        }
        SignatureTimeSeries timeSeries = new SignatureTimeSeries(representations);
        return timeSeries;
    }

    protected Temporal readCaptureDateAndTime() throws IOException {
        int year = this.dataInputStream.readUnsignedShort();
        if (year == -1) {
            this.dataInputStream.skipBytes(7);
            return null;
        }
        byte month = this.dataInputStream.readByte();
        byte dayOfMonth = this.dataInputStream.readByte();
        LocalDate date = LocalDate.of(year, month, (int)dayOfMonth);
        byte hourOfDay = this.dataInputStream.readByte();
        if (hourOfDay == -1) {
            this.dataInputStream.skipBytes(4);
            return date;
        }
        byte minute = this.dataInputStream.readByte();
        byte second = this.dataInputStream.readByte();
        short millis = this.dataInputStream.readShort();
        if (millis == -1) {
            millis = 0;
        }
        OffsetTime time = OffsetTime.of(hourOfDay, minute, second, millis * 1000, ZoneOffset.UTC);
        return date.atTime(time);
    }

    protected int readCaptureDeviceTechnologyId() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    protected int readChannelDescriptionPreamble() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    protected Set<ChannelData<?>> readChannelDescriptions() throws IOException {
        SortedSet<ChannelType<?>> channelTypes = this.readChannelInclusionField();
        return this.readChannelDescriptions(channelTypes);
    }

    protected Set<ChannelData<?>> readChannelDescriptions(Set<ChannelType<?>> channelTypes) throws IOException {
        HashSet channels = new HashSet(channelTypes.size());
        for (ChannelType<?> channelType : channelTypes) {
            int channelDescriptionPreamble = this.readChannelDescriptionPreamble();
            int min = -1;
            int max = -1;
            Number scale = 1;
            if ((channelDescriptionPreamble & 0x80) != 0) {
                scale = this.readScalingValue();
            }
            if ((channelDescriptionPreamble & 0x40) != 0) {
                min = this.readMinimumPossibleValue(channelType);
            }
            if ((channelDescriptionPreamble & 0x20) != 0) {
                max = this.readMaximumPossibleValue(channelType);
            }
            if ((channelDescriptionPreamble & 0x10) != 0) {
                this.dataInputStream.skipBytes(2);
            }
            if ((channelDescriptionPreamble & 8) != 0) {
                this.dataInputStream.skipBytes(2);
            }
            boolean constant = (channelDescriptionPreamble & 4) != 0;
            channels.add(new ChannelData(channelType, min, max, scale, null, constant));
        }
        return channels;
    }

    protected SortedSet<ChannelType<?>> readChannelInclusionField() throws IOException {
        int channelInclusionField = this.dataInputStream.readUnsignedShort();
        TreeSet channelTypes = new TreeSet();
        for (ChannelType<?> channelType : ChannelType.ALL) {
            if ((channelInclusionField & 1 << channelType.getInclusionBit()) == 0) continue;
            channelTypes.add(channelType);
        }
        return channelTypes;
    }

    protected int readExtendedDataLength() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    protected int readMaximumPossibleValue(ChannelType<?> channelType) throws IOException {
        return channelType.getDecoded(this.dataInputStream.readUnsignedShort());
    }

    protected int readMinimumPossibleValue(ChannelType<?> channelType) throws IOException {
        return channelType.getDecoded(this.dataInputStream.readUnsignedShort());
    }

    protected int readNumberOfQualityBlocks() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    protected int readNumberOfRepresentations() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    protected int readNumberOfSamplePoints() throws IOException {
        int b1 = this.dataInputStream.readUnsignedByte();
        int b2 = this.dataInputStream.readUnsignedByte();
        int b3 = this.dataInputStream.readUnsignedByte();
        return (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    protected Representation readRepresentation() throws IOException {
        this.dataInputStream.skipBytes(4);
        Temporal captureDateAndTime = this.readCaptureDateAndTime();
        int captureDeviceTechnology = this.readCaptureDeviceTechnologyId();
        this.dataInputStream.skipBytes(4);
        int numberOfQualityBlocks = this.readNumberOfQualityBlocks();
        this.dataInputStream.skipBytes(5 * numberOfQualityBlocks);
        Set<ChannelData<?>> channelDescriptions = this.readChannelDescriptions();
        Representation representation = new Representation(captureDeviceTechnology, channelDescriptions, captureDateAndTime);
        this.readSamplePoints(representation);
        int extendedDataLength = this.readExtendedDataLength();
        this.dataInputStream.skipBytes(extendedDataLength);
        return representation;
    }

    protected List<Representation> readRepresentations(int numberOfRepresentations) throws IOException {
        ArrayList<Representation> representations = new ArrayList<Representation>(numberOfRepresentations);
        for (int index = 0; index < numberOfRepresentations; ++index) {
            representations.add(this.readRepresentation());
        }
        return representations;
    }

    protected void readSamplePoints(Representation representation) throws IOException {
        int numberOfSamplePoints = this.readNumberOfSamplePoints();
        SortedSet<ChannelType<?>> channelTypes = representation.getChannelTypes();
        for (int index = 0; index < numberOfSamplePoints; ++index) {
            WritableSamplePoint samplePoint = new WritableSamplePoint();
            for (ChannelType channelType : channelTypes) {
                if (representation.isConstant(channelType)) continue;
                samplePoint.put(channelType, channelType.getDecoded(this.dataInputStream.readUnsignedShort()));
            }
            representation.add(samplePoint);
        }
    }

    protected double readScalingValue() throws IOException {
        int scalingValue = this.dataInputStream.readUnsignedShort();
        int biasedExponent = scalingValue >>> 11;
        double significand = scalingValue & 0x7FF;
        return (1.0 + significand / 2048.0) * Math.pow(2.0, biasedExponent - 16);
    }
}

