/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pentablet.timeseries.serialize;

import de.intarsys.pentablet.timeseries.Representation;
import de.intarsys.pentablet.timeseries.SignatureTimeSeries;
import de.intarsys.pentablet.timeseries.serialize.RepresentationBdbSerializer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SignatureTimeSeriesBdbSerializer {
    private static final String FORMATIDENTIFIER = "SDI\u0000";
    private static final String VERSIONNUMBER = "021\u0000";
    private boolean closed = false;
    private DataOutputStream dataOutputStream;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public SignatureTimeSeriesBdbSerializer() {
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    public byte[] serializeTimeSeries(SignatureTimeSeries timeSeries) throws IOException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (timeSeries.size() < 1) {
            throw new IllegalArgumentException();
        }
        try {
            this.writeFormatIdentifier();
            this.writeVersionNumber();
            this.writeRecordLengthPlaceholder();
            this.writeNumberOfRepresentations(timeSeries);
            this.writeCertificationFlag();
            this.writeRepresentations(timeSeries);
        }
        finally {
            this.closed = true;
            this.dataOutputStream.close();
        }
        byte[] bytes = this.outputStream.toByteArray();
        bytes[8] = (byte)(bytes.length >>> 24 & 0xFF);
        bytes[9] = (byte)(bytes.length >>> 16 & 0xFF);
        bytes[10] = (byte)(bytes.length >>> 8 & 0xFF);
        bytes[11] = (byte)(bytes.length >>> 0 & 0xFF);
        return bytes;
    }

    protected void writeCertificationFlag() throws IOException {
        this.dataOutputStream.writeByte(0);
    }

    protected void writeFormatIdentifier() throws IOException {
        this.dataOutputStream.writeBytes(FORMATIDENTIFIER);
    }

    protected void writeNumberOfRepresentations(SignatureTimeSeries timeSeries) throws IOException {
        this.dataOutputStream.writeShort(timeSeries.size());
    }

    protected void writeRecordLengthPlaceholder() throws IOException {
        this.dataOutputStream.writeInt(0);
    }

    protected void writeRepresentation(Representation representation) throws IOException {
        RepresentationBdbSerializer representationSerializer = new RepresentationBdbSerializer();
        this.dataOutputStream.write(representationSerializer.serializeRepresentation(representation));
    }

    protected void writeRepresentations(SignatureTimeSeries timeSeries) throws IOException {
        for (int index = 0; index < timeSeries.size(); ++index) {
            this.writeRepresentation(timeSeries.get(index));
        }
    }

    protected void writeVersionNumber() throws IOException {
        this.dataOutputStream.writeBytes(VERSIONNUMBER);
    }
}

