/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.app.pdf.tags;

import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.app.tags.TagDetector;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.tag.TagTools;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFContentTagDetector
extends CommonDocumentProcessor {
    private static final Logger Log = LoggerFactory.getLogger(PDFContentTagDetector.class);

    public PDFContentTagDetector(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    protected void basicRun() throws Exception {
        super.basicRun();
        Object docImpl = this.getDocument().getImpl();
        if (docImpl instanceof PDDocument) {
            TagDetector detector = new TagDetector();
            detector.setDocument((PDDocument)docImpl);
            detector.setKeywordSyntax(ArgTools.getString((IArgs)this.getArgs(), (String)"syntax", (String)"prefixed"));
            detector.setKeywordCaseSensitive(true);
            List tags = detector.perform();
            TagTools.addTags((Object)this.getDocument(), (List)tags);
            this.setResult(tags);
        } else {
            Log.info("can't detect keywords in " + this.getDocument().getLocator().getPath());
        }
        this.ok();
    }
}

