/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.pdf.common;

import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.tools.application.SimpleWaterMark;
import de.intarsys.processor.common.ProcessorWatchdog;
import de.intarsys.processor.document.standard.IDocumentProcessor;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.processor.pdf.common.PACKAGE;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessageBundle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

@SingletonClass
public class WaterMarkCreator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String WATER_MARK_TEXT_DEFAULT = "intarsys GmbH";
    private static final Object KEY_MARK_ON_SAVE = new Object();
    private static final Object KEY_WATER_MARKED = new Object();
    public static final String ARG_TRANSPARENT = "transparent";
    private static final WaterMarkCreator INSTANCE = new WaterMarkCreator();
    private ProcessorWatchdog watchdog;
    private String waterMarkText;
    private boolean started = false;

    public static WaterMarkCreator get() {
        return INSTANCE;
    }

    protected static boolean isMarkOnSave(IAttributeSupport document) {
        return document.getAttribute(KEY_MARK_ON_SAVE) != null;
    }

    protected static boolean isWaterMarked(IAttributeSupport document) {
        return document.getAttribute(KEY_WATER_MARKED) != null;
    }

    protected static void setMarkOnSave(IAttributeSupport document, Object value) {
        document.setAttribute(KEY_MARK_ON_SAVE, value);
    }

    protected static void setWaterMarked(IAttributeSupport document) {
        document.setAttribute(KEY_WATER_MARKED, (Object)Boolean.TRUE);
    }

    protected WaterMarkCreator() {
    }

    protected void basicMark(PDDocument document, IArgs args) {
        boolean transparent = ArgTools.getBoolStrict((IArgs)args, (String)ARG_TRANSPARENT, (boolean)true);
        SimpleWaterMark waterMark = new SimpleWaterMark(document, this.getWaterMarkText());
        if (!transparent) {
            waterMark.setStrokingAlpha(1.0f);
            waterMark.setNonStrokingAlpha(1.0f);
        }
        waterMark.doIt();
    }

    public void doMark(BufferedImage image) {
        Graphics2D gc = image.createGraphics();
        Font font = new Font("Arial", 1, 24);
        gc.setFont(font);
        gc.setColor(Color.BLACK);
        gc.rotate(Math.toRadians(45.0));
        gc.drawString(this.getWaterMarkText(), 10, 10);
        gc.dispose();
    }

    public void doMark(IDocument document) {
        this.doMark(document, (IArgs)Args.create());
    }

    public void doMark(IDocument document, IArgs args) {
        if (!(document.getImpl() instanceof PDDocument)) {
            throw new LicenseException("watermark not supported for " + document);
        }
        this.doMark((PDDocument)document.getImpl(), args);
    }

    public void doMark(PDDocument document) {
        this.doMark(document, (IArgs)Args.create());
    }

    public void doMark(PDDocument document, IArgs args) {
        if (WaterMarkCreator.isWaterMarked((IAttributeSupport)document)) {
            return;
        }
        this.basicMark(document, args);
        WaterMarkCreator.setWaterMarked((IAttributeSupport)document);
    }

    public void doMarkOnSave(IDocument document) {
        this.start();
        WaterMarkCreator.setMarkOnSave((IAttributeSupport)document, Boolean.TRUE);
    }

    protected String getWaterMarkText() {
        try {
            if (this.waterMarkText == null) {
                this.waterMarkText = Msg.getPattern("WaterMarkCreator.text");
                if (this.waterMarkText == null) {
                    this.waterMarkText = WATER_MARK_TEXT_DEFAULT;
                }
            }
        }
        catch (Exception e) {
            this.waterMarkText = WATER_MARK_TEXT_DEFAULT;
        }
        return this.waterMarkText;
    }

    public void setWaterMarkText(String waterMarkText) {
        this.waterMarkText = waterMarkText;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.watchdog = new ProcessorWatchdog(Outlet.get()){

            protected void processorCreated(IProcessor processor) {
                IDocument document = ((IDocumentProcessor)processor).getDocument();
                if (WaterMarkCreator.isMarkOnSave((IAttributeSupport)document)) {
                    new SimpleWaterMark((PDDocument)document.getImpl(), WaterMarkCreator.this.getWaterMarkText()).doIt();
                    WaterMarkCreator.setMarkOnSave((IAttributeSupport)document, null);
                    WaterMarkCreator.setWaterMarked((IAttributeSupport)document);
                }
            }

            protected boolean supports(IProcessor processor) {
                return processor instanceof IDocumentProcessor;
            }
        };
        this.watchdog.setLabel("watermark creator watch processors");
        this.watchdog.start();
    }

    public synchronized void stop() {
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.started = false;
    }
}

