/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.security.KeyStoreTools;
import de.intarsys.tools.ssl.IConfigurableKeyManagerProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableKeyManagerProvider
implements IConfigurableKeyManagerProvider {
    private static final Logger Log = LoggerFactory.getLogger(ConfigurableKeyManagerProvider.class);
    private KeyStore keyStore;
    private Secret keyStorePassword;
    private Secret keyPassword;
    private String provider;
    private String keyStoreType;
    private ILocator keyStoreLocator;

    public ConfigurableKeyManagerProvider() {
    }

    protected ConfigurableKeyManagerProvider(ConfigurableKeyManagerProvider other) {
        this.keyPassword = other.keyPassword;
        this.keyStore = other.keyStore;
        this.keyStoreLocator = other.keyStoreLocator;
        this.keyStorePassword = other.keyStorePassword;
        this.keyStoreType = other.keyStoreType;
        this.provider = other.provider;
    }

    @Override
    public KeyManager[] createKeyManagers() throws GeneralSecurityException, IOException {
        KeyStore tmpKeyStore = this.getOrCreateKeyStore();
        KeyManager[] managers = null;
        if (tmpKeyStore == null) {
            Log.debug("{} SSLContext will use default key", (Object)this);
        } else {
            Log.debug("{} SSLContext will use explicit key from {}", (Object)this, (Object)this.getKeyStoreLocator());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(tmpKeyStore, CryptoTools.getChars((Secret)this.getKeyPassword()));
            managers = keyManagerFactory.getKeyManagers();
        }
        return managers;
    }

    public Secret getKeyPassword() {
        return this.keyPassword;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public ILocator getKeyStoreLocator() {
        return this.keyStoreLocator;
    }

    public Secret getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    protected KeyStore getOrCreateKeyStore() throws IOException, GeneralSecurityException {
        if (this.getKeyStore() == null) {
            return KeyStoreTools.createJavaKeyStore((ILocator)this.getKeyStoreLocator(), (String)(this.getKeyStoreType() == null ? KeyStore.getDefaultType() : this.getKeyStoreType()), (char[])CryptoTools.getChars((Secret)this.getKeyStorePassword()));
        }
        return this.getKeyStore();
    }

    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setKeyPassword(Secret keyPassword) {
        this.keyPassword = keyPassword;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public void setKeyStoreLocator(ILocator keyStoreLocator) {
        this.keyStoreLocator = keyStoreLocator;
    }

    @Override
    public void setKeyStorePassword(Secret keyStoreSecret) {
        this.keyStorePassword = keyStoreSecret;
    }

    @Override
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }
}

