/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.app.signature;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CertificateIdentityPrincipalFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.PrincipalEqualityPrincipalFilter;
import de.intarsys.security.device.pronext.client.dto.SadTbs;
import de.intarsys.security.device.pronext.client.dto.SignatureActivationData;
import de.intarsys.security.device.pronext.client.dto.TokenAugmentationRequest;
import de.intarsys.security.device.pronext.device.AuthenticationContext;
import de.intarsys.security.device.pronext.device.AuthenticationContextRefresher;
import de.intarsys.security.device.pronext.device.ProNEXTCertificateProvider;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.security.device.pronext.device.ProNEXTDevicePreferences;
import de.intarsys.security.device.pronext.device.ProNEXTPrincipal;
import de.intarsys.security.device.pronext.device.ProNEXTPrincipalStore;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ProNEXTSigner
extends CommonBatchSigner {
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList("SHA-256", "SHA-384", "SHA-512");
    private AuthenticationContext authenticationContext;
    private AuthenticationContextRefresher authenticationContextRefresher;
    private ProNEXTPrincipal principal;
    private Object signerIdentifier;
    private IPrincipalFilter principalFilter;
    private boolean includeCertificateChain;
    private boolean signerSelectionInteractive;
    private boolean signerSelectionUnique;
    private long refreshInterval;
    private SignatureAlgorithm signatureAlgorithm;

    public ProNEXTSigner(ProNEXTDevice device) {
        super((CommonDevice)device);
    }

    private IConversation<SignatureActivationData> authorizeSignature(List<SignatureTask> tasks) {
        try {
            ArrayList<IDigest> digests = new ArrayList<IDigest>();
            for (SignatureTask task : tasks) {
                digests.add(task.toBeSignedData.getDigest());
            }
            String keyId = this.getPrincipal().getKeyId();
            KeyPair sadKeyPair = this.generateSadKeyPair();
            TokenAugmentationRequest augmentationRequest = new TokenAugmentationRequest(this.getAuthenticationContext().getToken(), sadKeyPair.getPublic().getEncoded());
            byte[] augmentedToken = this.getDevice().getIdpClient().augmentToken(augmentationRequest);
            String digestAlgorithmName = ((IDigest)digests.get(0)).getAlgorithmName();
            if (this.getSignatureAlgorithm().getEncodingAlgorithm().equals((Object)EncodingAlgorithm.ALG_PSS)) {
                this.setAlgorithmParameterSpec(PSSEncoding.createPSSParameterSpec((String)digestAlgorithmName));
            }
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithm((String)digestAlgorithmName);
            List<byte[]> hashValues = digests.stream().map(IDigest::getBytes).collect(Collectors.toList());
            SadTbs sadTbs = new SadTbs(augmentedToken, keyId, new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithm.getOid()), (ASN1Encodable)DERNull.INSTANCE), hashValues);
            byte[] sadSignature = this.signSad(sadTbs.toASN1Primitive().getEncoded("DER"), sadKeyPair.getPrivate());
            SignatureActivationData sad = new SignatureActivationData(sadTbs, sadSignature);
            return Conversation.completed((Object)sad);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)new SecurityApplicationException((Throwable)e));
        }
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            try {
                this.getAuthenticationContext().ensureAuthenticated();
                this.startAuthenticationContectRefresh();
                this.principal = this.selectPrincipal();
                this.setCertificatePath(new IX509PublicKeyCertificate[]{this.principal.getX509PublicKeyCertificate()});
                if (this.isIncludeCertificateChain()) {
                    this.buildCertificatePath();
                }
            }
            catch (SecurityApplicationException | ObjectCreationException e) {
                throw new SecurityApplicationException(e);
            }
        });
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.stopAuthenticationContectRefresh();
        this.getAuthenticationContext().deauthenticate();
        this.principal = null;
        this.setCertificatePath(null);
    }

    protected void basicDispose() {
        super.basicDispose();
        try {
            this.deauthenticate();
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
    }

    protected IConversation<?> basicSignAuthorized() {
        List tasks = this.getTasks();
        if (tasks == null || tasks.isEmpty()) {
            return Conversation.completed(null);
        }
        return this.authorizeSignature(tasks).thenCompose(sad -> this.createSignature((SignatureActivationData)sad));
    }

    protected AlgorithmParameterSpec createAlgorithmParameterSpec() {
        if (this.getHashAlgorithmName() == null) {
            return null;
        }
        if (this.getSignatureAlgorithm().getEncodingAlgorithm().equals((Object)EncodingAlgorithm.ALG_PSS)) {
            return PSSEncoding.createPSSParameterSpec((String)this.getHashAlgorithmName());
        }
        return null;
    }

    protected IPrincipalFilter createDefaultPrincipalFilter(ProNEXTPrincipalStore principalStore) throws ObjectCreationException {
        Object sid = this.getSignerIdentifier();
        if (sid instanceof IPrincipal) {
            return new PrincipalEqualityPrincipalFilter((IPrincipal)sid);
        }
        ProNEXTCertificateProvider certificateProvider = new ProNEXTCertificateProvider(principalStore);
        if (this.isSignerSelectionInteractive()) {
            throw new IllegalArgumentException("interactive signature selection not implemented");
        }
        Iterator certificates = CertificateProviderTools.lookupCertificates((ICertificateProvider)certificateProvider, (Object)sid);
        if (certificates.hasNext()) {
            IX509Certificate certificate = (IX509Certificate)certificates.next();
            return new CertificateIdentityPrincipalFilter(certificate);
        }
        return new IPrincipalFilter(){

            public boolean accept(IPrincipal principal) {
                return false;
            }
        };
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return ProNEXTCertificateProvider.getPrincipal((IX509Certificate)certificate);
    }

    private IConversation<Void> createSignature(SignatureActivationData sad) {
        try {
            List<byte[]> signatureValues = this.getDevice().getSsaClient().remoteSign(sad);
            List signatures = signatureValues.stream().map(signatureValue -> SignatureData.create((byte[])signatureValue)).collect(Collectors.toList());
            this.tasksComplete(signatures);
            return Conversation.completed(null);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected KeyPair generateSadKeyPair() throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        keyPairGenerator.initialize(new ECGenParameterSpec("secp521r1"));
        return keyPairGenerator.generateKeyPair();
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public ProNEXTDevice getDevice() {
        return (ProNEXTDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.getSignatureAlgorithm().getEncryptionAlgorithm().getName();
    }

    public String getPreferredHashAlgorithmName() {
        return ProNEXTDevicePreferences.get().getSignatureHashAlgorithm();
    }

    public ProNEXTPrincipal getPrincipal() {
        return this.principal;
    }

    public IPrincipalFilter getPrincipalFilter() {
        return this.principalFilter;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Object getSignerIdentifier() {
        return this.signerIdentifier;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    public boolean isBasic() {
        return true;
    }

    public boolean isIncludeCertificateChain() {
        return this.includeCertificateChain;
    }

    public boolean isSignerSelectionInteractive() {
        return this.signerSelectionInteractive;
    }

    public boolean isSignerSelectionUnique() {
        return this.signerSelectionUnique;
    }

    protected ProNEXTPrincipal selectPrincipal() throws ObjectCreationException, SecurityApplicationException {
        Iterator<ProNEXTPrincipal> principals;
        ProNEXTPrincipalStore principalStore = new ProNEXTPrincipalStore(this.getDevice(), this.getAuthenticationContext());
        IPrincipalFilter principalFilter = this.getPrincipalFilter();
        if (principalFilter == null) {
            principalFilter = this.createDefaultPrincipalFilter(principalStore);
        }
        if ((principals = principalStore.lookupPrincipals(principalFilter)).hasNext()) {
            ProNEXTPrincipal principal = principals.next();
            if (this.isSignerSelectionUnique() && principals.hasNext()) {
                throw new SecurityApplicationException("Ambiguous signer certificate selection.");
            }
            return principal;
        }
        throw new SecurityApplicationException("No keys available.");
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setHashAlgorithmName(String hashAlgorithmName) throws SecurityApplicationException {
        super.setHashAlgorithmName(hashAlgorithmName);
        this.setAlgorithmParameterSpec(this.createAlgorithmParameterSpec());
    }

    public void setIncludeCertificateChain(boolean includeCertificateChain) {
        this.includeCertificateChain = includeCertificateChain;
    }

    public void setPrincipalFilter(IPrincipalFilter principalFilter) {
        this.principalFilter = principalFilter;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setSignerIdentifier(Object signerIdentifier) {
        this.signerIdentifier = signerIdentifier;
    }

    public void setSignerSelectionInteractive(boolean signerSelectionInteractive) {
        this.signerSelectionInteractive = signerSelectionInteractive;
    }

    public void setSignerSelectionUnique(boolean signerSelectionUnique) {
        this.signerSelectionUnique = signerSelectionUnique;
    }

    protected byte[] signSad(byte[] sadTbs, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA256withECDSA");
        signer.initSign(privateKey);
        signer.update(sadTbs);
        return signer.sign();
    }

    protected void startAuthenticationContectRefresh() {
        this.authenticationContextRefresher = new AuthenticationContextRefresher(this.getAuthenticationContext());
        this.authenticationContextRefresher.setRefreshInterval(this.getRefreshInterval());
        this.authenticationContextRefresher.start();
    }

    protected void stopAuthenticationContectRefresh() {
        if (this.authenticationContextRefresher == null) {
            return;
        }
        this.authenticationContextRefresher.stop();
        this.authenticationContextRefresher = null;
    }
}

