/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.app.signature;

import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.security.device.pronext.app.signature.ProNEXTSigner;
import de.intarsys.security.device.pronext.device.AuthenticationContext;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public class ProNEXTSignerFactory
extends CommonSecurityApplicationFactory<ProNEXTDevice, ProNEXTSigner> {
    public static final String ARG_AUTHENTICATION_CONTEXT = "authenticationContext";
    public static final String ARG_REFRESH_INTERVAL = "refreshInterval";
    public static final String ARG_SIGNER_SELECTION_UNIQUE = "signerSelectionUnique";
    public static final String ARG_SIGNER_SELECTION_INTERACTIVE = "signerSelectionInteractive";
    public static final String ARG_AUTHENTICATION_DATA = "authenticationData";
    public static final String ARG_PRINCIPAL_FILTER = "principalFilter";
    public static final String ARG_SIGNATURE_ALGORITHM = "signatureAlgorithm";

    protected ProNEXTSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        ProNEXTDevice device = (ProNEXTDevice)this.getDevice(args);
        ProNEXTSigner signer = new ProNEXTSigner(device);
        String signatureAlgorithm = ArgTools.getString((IArgs)args, (String)ARG_SIGNATURE_ALGORITHM, null);
        if (StringTools.isEmpty((String)signatureAlgorithm)) {
            signer.setSignatureAlgorithm(SignatureAlgorithm.ALG_RSASSA_PSS);
        } else {
            signer.setSignatureAlgorithm(SignatureAlgorithm.lookupAlgorithm((String)signatureAlgorithm));
        }
        signer.setPrincipalFilter(this.getPrincipalFilter(args, ARG_PRINCIPAL_FILTER));
        signer.setSignerIdentifier(ArgTools.getObject((IArgs)args, (String)"signerIdentifier", (Object)AllCertificateFilter.UNIQUE));
        AuthenticationContext authenticationContext = (AuthenticationContext)ArgTools.getPath((IArgs)args, (String)ARG_AUTHENTICATION_CONTEXT);
        if (authenticationContext == null) {
            IArgs authenticationData = ArgTools.getArgs((IArgs)args, (String)ARG_AUTHENTICATION_DATA, (IArgs)Args.create());
            authenticationContext = device.createAuthenticationContext(authenticationData);
        }
        signer.setAuthenticationContext(authenticationContext);
        signer.setSignerSelectionInteractive(ArgTools.getBool((IArgs)args, (String)ARG_SIGNER_SELECTION_INTERACTIVE, (boolean)false));
        signer.setSignerSelectionUnique(ArgTools.getBool((IArgs)args, (String)ARG_SIGNER_SELECTION_UNIQUE, (boolean)false));
        signer.setRefreshInterval(ArgTools.getLong((IArgs)args, (String)ARG_REFRESH_INTERVAL, (long)300L));
        signer.setIncludeCertificateChain(ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificateChain", (boolean)true));
        return signer;
    }

    protected IPrincipalFilter getPrincipalFilter(IArgs args, String name) throws ObjectCreationException {
        Object value = args.get(name);
        return PrincipalFilterTools.createFilter((Object)value);
    }
}

