/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRemoteClient {
    private static final Logger Log = LoggerFactory.getLogger(CommonRemoteClient.class);
    private String baseUri;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;
    private Client client;

    protected CommonRemoteClient(String baseUri) {
        this.baseUri = baseUri;
    }

    protected WebTarget baseTarget() {
        return this.getClient().target(this.getBaseUri());
    }

    protected Client createClient() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.getSslContext() != null) {
            builder.sslContext(this.getSslContext());
        }
        if (this.getHostnameVerifier() != null) {
            builder.hostnameVerifier(this.getHostnameVerifier());
        }
        return (Client)((Client)builder.build().register((Object)new JacksonXmlBindJsonProvider())).register((Object)new LoggingFeature(Log));
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    protected Client getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void initialize() {
        this.client = this.createClient();
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

