/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import de.intarsys.security.device.pronext.client.CommonRemoteClient;
import de.intarsys.security.device.pronext.client.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpAuthenticationClient
extends CommonRemoteClient {
    private static final String PATH_AUTHENTICATE_TLS = "/auth/tls";
    private static final String PATH_AUTHENTICATE_TOKEN = "/auth/jwt";
    private static final Logger Log = LoggerFactory.getLogger(IdpAuthenticationClient.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public IdpAuthenticationClient(String idpUrl) {
        super(idpUrl);
    }

    public byte[] authenticateMtls() throws IOException {
        WebTarget target = this.baseTarget().path(PATH_AUTHENTICATE_TLS);
        Invocation.Builder builder = target.request();
        Log.debug("Authenticating with {} using mTLS", (Object)target.getUri());
        try {
            Response response = builder.get();
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                byte[] token = (byte[])response.readEntity(byte[].class);
                return token;
            }
            throw new IOException(Msg.getString("IdpAuthenticationClient.error.authentication", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("IdpAuthenticationClient.error.connection", new Object[0]), e);
        }
    }

    public byte[] authenticateToken(String authToken) throws IOException {
        WebTarget target = this.baseTarget().path(PATH_AUTHENTICATE_TOKEN);
        Invocation.Builder builder = target.request().header("Authorization", (Object)("Bearer " + authToken)).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE});
        Log.debug("Authenticating with {} using token", (Object)target.getUri());
        try {
            Response response = builder.get();
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                byte[] token = (byte[])response.readEntity(byte[].class);
                return token;
            }
            throw new IOException(Msg.getString("IdpAuthenticationClient.error.authentication", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("IdpAuthenticationClient.error.connection", new Object[0]), e);
        }
    }
}

