/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import de.intarsys.security.device.pronext.client.CommonRemoteClient;
import de.intarsys.security.device.pronext.client.IdpAuthenticationClient;
import de.intarsys.security.device.pronext.client.PACKAGE;
import de.intarsys.security.device.pronext.client.dto.TokenAugmentationRequest;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpClient
extends CommonRemoteClient {
    private static final String PATH_AUGMENT = "/id-token/sad";
    private static final String PATH_REFRESH = "/id-token/refresh";
    public static final String DEFAULT_IDP_URL = "https://login.bnotk.de/auth/realms/RemoteSignature";
    private static final Logger Log = LoggerFactory.getLogger(IdpClient.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public IdpClient() {
        super(DEFAULT_IDP_URL);
    }

    public IdpClient(String idpUrl) {
        super(idpUrl);
    }

    public byte[] augmentToken(TokenAugmentationRequest request) throws IOException {
        WebTarget target = this.baseTarget().path(PATH_AUGMENT);
        Invocation.Builder builder = target.request();
        Log.debug("Augmenting token via {}", (Object)target.getUri());
        try {
            Response response = builder.post(Entity.entity((Object)request, (String)"application/json"));
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                byte[] result = (byte[])response.readEntity(byte[].class);
                return result;
            }
            throw new IOException(Msg.getString("IdpClient.error.augment", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("IdpClient.error.connection", new Object[0]), e);
        }
    }

    public IdpAuthenticationClient createAuthenticationClient(SSLContext clientTlsContext) {
        IdpAuthenticationClient authenticationClient = new IdpAuthenticationClient(this.getBaseUri());
        authenticationClient.setHostnameVerifier(this.getHostnameVerifier());
        authenticationClient.setSslContext(clientTlsContext);
        return authenticationClient;
    }

    public byte[] refreshToken(byte[] token) throws IOException {
        WebTarget target = this.baseTarget().path(PATH_REFRESH);
        Invocation.Builder builder = target.request();
        Log.debug("Refreshing token via {}", (Object)target.getUri());
        try {
            Response response = builder.post(Entity.entity((Object)token, (String)"application/octet-stream"));
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                byte[] result = (byte[])response.readEntity(byte[].class);
                return result;
            }
            throw new IOException(Msg.getString("IdpClient.error.refresh", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("IdpClient.error.connection", new Object[0]), e);
        }
    }
}

