/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import de.intarsys.security.device.pronext.client.CommonRemoteClient;
import de.intarsys.security.device.pronext.client.PACKAGE;
import de.intarsys.security.device.pronext.client.dto.RemoteSignatureKeyJson;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerClient
extends CommonRemoteClient {
    private static final String APPLICATION_REMOTE_SIGNATURE = "RemoteSignature";
    private static final String PARAM_APPLICATION = "application";
    private static final String PATH_CERTIFICATES = "/resources/certificates";
    public static final String DEFAULT_KEY_MANAGER_URL = "https://eid.bnotk.de/KeyManager";
    private static final Logger Log = LoggerFactory.getLogger(KeyManagerClient.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public KeyManagerClient() {
        super(DEFAULT_KEY_MANAGER_URL);
    }

    public KeyManagerClient(String keyManagerUrl) {
        super(keyManagerUrl);
    }

    public List<RemoteSignatureKeyJson> listKeys(byte[] token) throws IOException {
        WebTarget target = this.baseTarget().path(PATH_CERTIFICATES).queryParam(PARAM_APPLICATION, new Object[]{APPLICATION_REMOTE_SIGNATURE});
        Invocation.Builder builder = target.request().header("Authorization", (Object)("Bearer " + Base64.getEncoder().encodeToString(token))).header("Accept", (Object)"application/json");
        Log.debug("Listing user keys via {}", (Object)target.getUri());
        try {
            Response response = builder.get();
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                RemoteSignatureKeyJson[] result = (RemoteSignatureKeyJson[])response.readEntity(RemoteSignatureKeyJson[].class);
                return List.of(result);
            }
            throw new IOException(Msg.getString("KeyManagerClient.error.list", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("KeyManagerClient.error.connection", new Object[0]), e);
        }
    }
}

