/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.ssl.DeviceKeyManager;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.pronext.client.IProNEXTAuthenticator;
import de.intarsys.security.device.pronext.client.IdpAuthenticationClient;
import de.intarsys.security.device.pronext.client.IdpClient;
import de.intarsys.security.device.smartcard.device.DispatchSmartcardDeviceProvider;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtlsAuthenticator
implements IProNEXTAuthenticator {
    private static final Logger Log = LoggerFactory.getLogger(MtlsAuthenticator.class);
    private IDevice authenticationDevice;
    private IdpClient idpClient;

    public MtlsAuthenticator(IdpClient idpClient) {
        this.idpClient = idpClient;
    }

    public MtlsAuthenticator(String idpUrl) {
        this(new IdpClient(idpUrl));
    }

    @Override
    public byte[] authenticate(IArgs authenticationData) throws SecurityApplicationException, IOException {
        try {
            IdpAuthenticationClient client = this.createIdpAuthenticationClient();
            return client.authenticateMtls();
        }
        catch (IOException | GeneralSecurityException e) {
            if (ExceptionTools.isInChain((Throwable)e, SSLHandshakeException.class)) {
                throw new AuthenticationFailed((Throwable)e);
            }
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    protected SSLContext createAuthenticationSSLContext() throws GeneralSecurityException, IOException {
        DeviceKeyManager keyManager = DeviceKeyManager.create((IDevice)this.getAuthenticationDevice());
        keyManager.addUnsupportedKeyType("EC");
        KeyManager[] keyManagers = new KeyManager[]{keyManager};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, null, null);
        return sslContext;
    }

    protected IDevice createDefaultAuthenticationDevice() {
        try {
            return DeviceTools.getDefaultDevice(DispatchSmartcardDeviceProvider.class);
        }
        catch (ObjectCreationException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            throw ExceptionTools.wrap((Throwable)e);
        }
    }

    public IdpAuthenticationClient createIdpAuthenticationClient() throws GeneralSecurityException, IOException {
        return this.getIdpClient().createAuthenticationClient(this.createAuthenticationSSLContext());
    }

    public synchronized IDevice getAuthenticationDevice() {
        if (this.authenticationDevice == null) {
            this.authenticationDevice = this.createDefaultAuthenticationDevice();
        }
        return this.authenticationDevice;
    }

    public IdpClient getIdpClient() {
        return this.idpClient;
    }

    @Override
    public boolean isAvailable() {
        return this.getAuthenticationDevice().listPrincipals(null).hasNext();
    }

    public void setAuthenticationDevice(IDevice authenticationDevice) {
        this.authenticationDevice = authenticationDevice;
    }

    public void setIdpClient(IdpClient idpClient) {
        this.idpClient = idpClient;
    }
}

