/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import de.intarsys.security.device.pronext.client.CommonRemoteClient;
import de.intarsys.security.device.pronext.client.PACKAGE;
import de.intarsys.security.device.pronext.client.dto.SignatureActivationData;
import de.intarsys.tools.message.IMessageBundle;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsaClient
extends CommonRemoteClient {
    private static final String PATH_SIGNING = "/signing";
    public static final String DEFAULT_SSA_URL = "https://eid.bnotk.de/ServerSigningApplication";
    private static final Logger Log = LoggerFactory.getLogger(SsaClient.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public SsaClient() {
        super(DEFAULT_SSA_URL);
    }

    public SsaClient(String ssaUrl) {
        super(ssaUrl);
    }

    public List<byte[]> remoteSign(SignatureActivationData sad) throws IOException {
        WebTarget target = this.baseTarget().path(PATH_SIGNING);
        Invocation.Builder builder = target.request();
        Log.debug("Signing remotely via {}", (Object)target.getUri());
        try {
            Response response = builder.post(Entity.entity((Object)sad.toASN1Primitive().getEncoded("DER"), (String)"application/octet-stream"));
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                byte[][] result = (byte[][])response.readEntity(byte[][].class);
                return List.of(result);
            }
            throw new IOException(Msg.getString("SsaClient.error.sign", new Object[]{response.getStatus(), response.getStatusInfo().getReasonPhrase()}));
        }
        catch (RuntimeException e) {
            throw new IOException(Msg.getString("SsaClient.error.connection", new Object[0]), e);
        }
    }
}

