/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import de.intarsys.security.app.AuthenticationFailed;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.pronext.client.IProNEXTAuthenticator;
import de.intarsys.security.device.pronext.client.IdpAuthenticationClient;
import de.intarsys.security.device.pronext.client.IdpClient;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthenticator
implements IProNEXTAuthenticator {
    private static final Logger Log = LoggerFactory.getLogger(TokenAuthenticator.class);
    public static final String ARG_USER_NAME = "userName";
    private IdpClient idpClient;
    private String issuer;
    private Secret sharedSecret;

    public TokenAuthenticator(IdpClient idpClient) {
        this.idpClient = idpClient;
    }

    public TokenAuthenticator(String idpUrl) {
        this(new IdpClient(idpUrl));
    }

    @Override
    public byte[] authenticate(IArgs authenticationData) throws SecurityApplicationException, IOException {
        try {
            String userName = ArgTools.getString((IArgs)authenticationData, (String)ARG_USER_NAME, null);
            if (StringTools.isEmpty((String)userName)) {
                throw new AuthenticationFailed("user name is missing");
            }
            String authenticationToken = this.createAuthenticationToken(userName);
            IdpAuthenticationClient client = this.createIdpAuthenticationClient();
            return client.authenticateToken(authenticationToken);
        }
        catch (JOSEException | IOException | GeneralSecurityException e) {
            if (ExceptionTools.isInChain((Throwable)e, SSLHandshakeException.class)) {
                throw new AuthenticationFailed(e);
            }
            throw new SecurityApplicationException(e.getMessage(), e);
        }
    }

    protected String createAuthenticationToken(String userName) throws JOSEException, GeneralSecurityException {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(userName).issuer(this.getIssuer()).expirationTime(Date.from(Instant.now().plus(5L, ChronoUnit.MINUTES))).build();
        if (this.getSharedSecret() == null) {
            return new PlainJWT(claimsSet).serialize();
        }
        MACSigner signer = new MACSigner(this.getSharedSecret().getBytes());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    protected IdpAuthenticationClient createIdpAuthenticationClient() throws GeneralSecurityException, IOException {
        return this.getIdpClient().createAuthenticationClient(SslContextProvider.get().createSslContext());
    }

    protected IdpClient getIdpClient() {
        return this.idpClient;
    }

    protected String getIssuer() {
        return this.issuer;
    }

    protected Secret getSharedSecret() {
        return this.sharedSecret;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public void setIdpClient(IdpClient idpClient) {
        this.idpClient = idpClient;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSharedSecret(Secret sharedSecret) {
        this.sharedSecret = sharedSecret;
    }
}

