/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.intarsys.security.device.pronext.client.dto.PACKAGE;
import de.intarsys.security.device.pronext.client.dto.RemoteSignatureKey;
import de.intarsys.tools.message.IMessageBundle;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RemoteSignatureKeyJson {
    private static final CertificateFactory certFactory;
    private static final Logger Log;
    private static final IMessageBundle Msg;
    private String id;
    private List<Link> links = Collections.emptyList();
    private byte[] value;
    private Map<String, Object> attributes;

    public RemoteSignatureKeyJson() {
    }

    public RemoteSignatureKeyJson(List<Link> links, byte[] value) {
        this.links = links;
        this.value = value;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public String getStringAttribute(String name, String defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public RemoteSignatureKey toRemoteSignatureKey() {
        X509Certificate x509;
        try {
            x509 = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(this.value));
        }
        catch (CertificateException e) {
            throw new IllegalStateException(Msg.getString("RemoteSignatureKeyJson.error.decodeCertificate", new Object[0]), e);
        }
        String keyId = this.links.stream().filter(link -> "hsm-wrapped-key".equals(link.getType())).map(Link::getId).findAny().orElseThrow(IllegalStateException::new);
        return new RemoteSignatureKey(x509, keyId);
    }

    static {
        Log = LoggerFactory.getLogger(RemoteSignatureKeyJson.class);
        Msg = PACKAGE.Messages;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Link {
        private String id;
        private String type;

        public Link() {
        }

        public Link(String id, String type) {
            this.id = id;
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

