/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.pronext.client.IProNEXTAuthenticator;
import de.intarsys.security.device.pronext.client.IdpClient;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationContext {
    private static final Logger Log = LoggerFactory.getLogger(AuthenticationContext.class);
    private byte[] token;
    private Instant tokenIssuingTime;
    private IdpClient idpClient;
    private IProNEXTAuthenticator authenticator;
    private IArgs authenticationData;

    public AuthenticationContext(IProNEXTAuthenticator authenticator, IArgs authenticationData, IdpClient idpClient) {
        this.authenticator = authenticator;
        this.authenticationData = authenticationData;
        this.idpClient = idpClient;
    }

    public AuthenticationContext(IProNEXTAuthenticator authenticator, IdpClient idpClient) {
        this(authenticator, (IArgs)Args.create(), idpClient);
    }

    public void authenticate() throws SecurityApplicationException {
        try {
            this.setToken(this.getAuthenticator().authenticate(this.getAuthenticationData()));
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    public void deauthenticate() {
        this.setToken(null);
    }

    public void ensureAuthenticated() throws SecurityApplicationException {
        if (this.isAuthenticated()) {
            if (this.shouldRefreshToken()) {
                this.refresh();
            }
        } else {
            this.authenticate();
        }
    }

    protected IArgs getAuthenticationData() {
        return this.authenticationData;
    }

    public IProNEXTAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    protected IdpClient getIdpClient() {
        return this.idpClient;
    }

    public byte[] getToken() {
        return this.token;
    }

    protected Instant getTokenIssuingTime() {
        return this.tokenIssuingTime;
    }

    public boolean isAuthenticated() {
        return this.getToken() != null;
    }

    public boolean isAuthenticationPrincipalAvailable() {
        return this.getAuthenticator().isAvailable();
    }

    public void refresh() throws SecurityApplicationException {
        try {
            this.setToken(this.getIdpClient().refreshToken(this.getToken()));
        }
        catch (IOException e) {
            throw new SecurityApplicationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setToken(byte[] token) {
        this.token = token;
        this.tokenIssuingTime = token == null ? null : Instant.now();
    }

    protected boolean shouldRefreshToken() {
        Instant refreshAfter = this.getTokenIssuingTime().plus(5L, ChronoUnit.MINUTES);
        return Instant.now().isAfter(refreshAfter);
    }
}

