/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.device.pronext.device.AuthenticationContext;
import de.intarsys.tools.concurrent.ThreadTools;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationContextRefresher {
    private static final Logger Log = LoggerFactory.getLogger(AuthenticationContextRefresher.class);
    private final AuthenticationContext authenticationContext;
    private ScheduledExecutorService refreshExecutor;
    private final Object lock = new Object();
    private long refreshInterval = 300L;

    public AuthenticationContextRefresher(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    protected void refresh() {
        try {
            Log.debug("proNEXT token auto-refresh");
            this.authenticationContext.refresh();
            this.wake();
        }
        catch (Throwable e) {
            Log.warn("proNEXT token auto-refresh failed", e);
        }
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void start() {
        if (this.refreshExecutor != null) {
            return;
        }
        this.refreshExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.newThreadFactoryDaemon((String)"proNEXT token auto-refresher"));
        this.refreshExecutor.scheduleWithFixedDelay(this::refresh, this.getRefreshInterval(), this.getRefreshInterval(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.refreshExecutor == null) {
            return;
        }
        this.refreshExecutor.shutdown();
        this.refreshExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getAuthenticationContext().isAuthenticated()) {
                this.start();
            } else {
                this.stop();
            }
        }
    }
}

