/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.filter.CertificateFilterIterator;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.device.pronext.device.ProNEXTPrincipal;
import de.intarsys.security.device.pronext.device.ProNEXTPrincipalStore;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.NullFilterIterator;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProNEXTCertificateProvider
extends CommonCertificateProvider {
    private static final Logger Log = LoggerFactory.getLogger(ProNEXTCertificateProvider.class);
    private static final Attribute ATTR_PRINCIPAL = new Attribute(ProNEXTPrincipal.class.getName());
    private final ProNEXTPrincipalStore principalStore;

    public static ProNEXTPrincipal getPrincipal(IX509Certificate certificate) {
        return (ProNEXTPrincipal)((Object)certificate.getAttribute((Object)ATTR_PRINCIPAL));
    }

    public ProNEXTCertificateProvider(ProNEXTPrincipalStore principalStore) {
        this.principalStore = principalStore;
    }

    protected boolean accept(IX509Certificate certificate, IX509CertificateFilter filter) {
        return true;
    }

    protected boolean accept(IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null) {
                // empty if block
            }
            if (selector.isPrivateKeyAccessible() != null && selector.isPrivateKeyAccessible().booleanValue()) {
                return false;
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return false;
            }
        }
        return true;
    }

    public String getLabel() {
        return "proNEXT";
    }

    public ProNEXTPrincipalStore getPrincipalStore() {
        return this.principalStore;
    }

    public Iterator<IX509Certificate> lookupCertificates(final IX509CertificateFilter filter) {
        if (!this.accept(filter)) {
            return Collections.emptyIterator();
        }
        Iterator<ProNEXTPrincipal> principals = this.getPrincipalStore().lookupPrincipals(p -> true);
        Object certificates = new ConversionIterator<ProNEXTPrincipal, IX509Certificate>(principals){

            protected IX509Certificate createTargetObject(ProNEXTPrincipal principal) {
                IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
                certificate.setAttribute((Object)ATTR_PRINCIPAL, (Object)principal);
                return certificate;
            }
        };
        certificates = new NullFilterIterator((Iterator)certificates);
        certificates = new FilterIterator<IX509Certificate>((Iterator)certificates){

            protected boolean accept(IX509Certificate certificate) {
                return ProNEXTCertificateProvider.this.accept(certificate, filter);
            }
        };
        CertificateFilterIterator filteredCertificates = new CertificateFilterIterator((Iterator)certificates, filter);
        return filteredCertificates;
    }
}

