/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pronext.client.IProNEXTAuthenticator;
import de.intarsys.security.device.pronext.client.IdpClient;
import de.intarsys.security.device.pronext.client.KeyManagerClient;
import de.intarsys.security.device.pronext.client.MtlsAuthenticator;
import de.intarsys.security.device.pronext.client.SsaClient;
import de.intarsys.security.device.pronext.device.AuthenticationContext;
import de.intarsys.security.device.pronext.device.ProNEXTDeviceProvider;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

@FactoredBy(factory=ProNEXTDeviceProvider.class)
public class ProNEXTDevice
extends CommonDevice<ProNEXTDeviceProvider> {
    public static final String LIC_PRODUCT = "de.intarsys.security.device.pronext";
    public static final String ARG_IDP_URL = "idpUrl";
    public static final String ARG_KEY_MANAGER_URL = "keyManagerUrl";
    public static final String ARG_SSA_URL = "ssaUrl";
    public static final String ARG_AUTHENTICATOR = "authenticator";
    private IdpClient idpClient;
    private KeyManagerClient keyManagerClient;
    private SsaClient ssaClient;
    private IProNEXTAuthenticator authenticator;

    protected ProNEXTDevice(ProNEXTDeviceProvider provider, String id) {
        super((CommonDeviceProvider)provider, id);
    }

    protected ISecurityApplication basicCreateApplication(Class<ISecurityApplication> clazz, IArgs args) throws ObjectCreationException {
        ISecurityApplication app = super.basicCreateApplication(clazz, args);
        this.triggerEvent((Event)new CreatedEvent((Object)this, (Object)app));
        return app;
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        String idpUrl = ArgTools.getString((IArgs)args, (String)ARG_IDP_URL, (String)"https://login.bnotk.de/auth/realms/RemoteSignature");
        String keyManagerUrl = ArgTools.getString((IArgs)args, (String)ARG_KEY_MANAGER_URL, (String)"https://eid.bnotk.de/KeyManager");
        String ssaUrl = ArgTools.getString((IArgs)args, (String)ARG_SSA_URL, (String)"https://eid.bnotk.de/ServerSigningApplication");
        this.setIdpClient(new IdpClient(idpUrl));
        this.setKeyManagerClient(new KeyManagerClient(keyManagerUrl));
        this.setSsaClient(new SsaClient(ssaUrl));
        IProNEXTAuthenticator authenticator = (IProNEXTAuthenticator)InstanceSpec.getAsInstance((IArgs)args, (String)ARG_AUTHENTICATOR, IProNEXTAuthenticator.class, () -> new MtlsAuthenticator(this.getIdpClient()));
        this.setAuthenticator(authenticator);
    }

    public AuthenticationContext createAuthenticationContext(IArgs authenticationData) {
        return new AuthenticationContext(this.getAuthenticator(), authenticationData, this.getIdpClient());
    }

    public IProNEXTAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public IdpClient getIdpClient() {
        return this.idpClient;
    }

    public KeyManagerClient getKeyManagerClient() {
        return this.keyManagerClient;
    }

    public SsaClient getSsaClient() {
        return this.ssaClient;
    }

    public void setAuthenticator(IProNEXTAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setIdpClient(IdpClient idpClient) {
        this.idpClient = idpClient;
    }

    public void setKeyManagerClient(KeyManagerClient keyManagerClient) {
        this.keyManagerClient = keyManagerClient;
    }

    public void setSsaClient(SsaClient ssaClient) {
        this.ssaClient = ssaClient;
    }
}

