/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.common.CommonDeviceFactoryBean;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pronext.client.IProNEXTAuthenticator;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.security.device.pronext.device.ProNEXTDevicePreferences;
import de.intarsys.security.device.pronext.device.ProNEXTDeviceProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProNEXTDeviceInstaller
extends CommonDeviceFactoryBean<ProNEXTDevice> {
    private static final Logger Log = LoggerFactory.getLogger(ProNEXTDeviceInstaller.class);
    private String idpUrl;
    private String keyManagerUrl;
    private String ssaUrl;
    private String signatureHashAlgorithm;
    private IProNEXTAuthenticator authenticator;

    protected IArgs createArgs() throws Exception {
        if (this.getKeyManagerUrl() != null) {
            return this.createArgsFromProperties();
        }
        if (ProNEXTDevicePreferences.get().getKeyManagerUrl() != null) {
            return this.createArgsFromPreferences();
        }
        return null;
    }

    protected IArgs createArgsFromPreferences() throws Exception {
        Log.debug("create args from preferences");
        Args args = Args.create();
        args.put("id", (Object)"default");
        args.put("idpUrl", (Object)ProNEXTDevicePreferences.get().getIdpUrl());
        args.put("keyManagerUrl", (Object)ProNEXTDevicePreferences.get().getKeyManagerUrl());
        args.put("ssaUrl", (Object)ProNEXTDevicePreferences.get().getSsaUrl());
        return args;
    }

    protected IArgs createArgsFromProperties() {
        Log.debug("create args from properties");
        Args args = Args.create();
        args.put("id", (Object)(StringTools.isEmpty((String)this.getId()) ? "default" : this.getId()));
        args.put("idpUrl", (Object)this.getIdpUrl());
        args.put("keyManagerUrl", (Object)this.getKeyManagerUrl());
        args.put("ssaUrl", (Object)this.getSsaUrl());
        args.put("authenticator", (Object)this.getAuthenticator());
        return args;
    }

    protected CommonDeviceProvider createDeviceProvider() {
        return (CommonDeviceProvider)DeviceTools.lookupDeviceProvider(ProNEXTDeviceProvider.class);
    }

    protected ProNEXTDevice createInstance() throws Exception {
        IArgs args = this.createArgs();
        if (args == null) {
            Log.debug("no device definition found, skip");
            return null;
        }
        return (ProNEXTDevice)this.getDeviceProviderOrDefault().createInstance(args);
    }

    public IProNEXTAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public ProNEXTDeviceProvider getDeviceProvider() {
        return (ProNEXTDeviceProvider)super.getDeviceProvider();
    }

    public ProNEXTDeviceProvider getDeviceProviderOrDefault() {
        return (ProNEXTDeviceProvider)super.getDeviceProviderOrDefault();
    }

    public String getIdpUrl() {
        return this.idpUrl;
    }

    public String getKeyManagerUrl() {
        return this.keyManagerUrl;
    }

    public Class<?> getObjectType() {
        return ProNEXTDevice.class;
    }

    public String getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public String getSsaUrl() {
        return this.ssaUrl;
    }

    public void setAuthenticator(IProNEXTAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
    }

    public void setKeyManagerUrl(String keyManagerUrl) {
        this.keyManagerUrl = keyManagerUrl;
    }

    public void setSignatureHashAlgorithm(String signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }

    public void setSsaUrl(String ssaUrl) {
        this.ssaUrl = ssaUrl;
    }
}

