/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;

public class ProNEXTDevicePreferences
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final String PREF_IDPURL = "idpUrl";
    public static final String PREF_KEYMANAGERURL = "keyManagerUrl";
    public static final String PREF_SSAURL = "ssaUrl";
    public static final String PREF_SIGNATURE_HASH_ALGORITHM = "signatureHashAlgorithm";
    private static final ProNEXTDevicePreferences ACTIVE = new ProNEXTDevicePreferences();
    private IPreferences preferences;
    private String idpUrl;
    private String keyManagerUrl;
    private String ssaUrl;
    private String signatureHashAlgorithm;

    public static ProNEXTDevicePreferences get() {
        return ACTIVE;
    }

    public ProNEXTDevicePreferences() {
        this.install();
    }

    protected IPreferences createPreferences() {
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences preferences = root.node(this.getPreferencesName());
        this.preferencesInit(preferences.restrict("DEFAULT"));
        return preferences;
    }

    public String getIdpUrl() {
        return this.idpUrl;
    }

    public String getKeyManagerUrl() {
        return this.keyManagerUrl;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.pronext";
    }

    public String getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public String getSsaUrl() {
        return this.ssaUrl;
    }

    protected void install() {
        this.preferencesRestore();
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_IDPURL, "https://login.bnotk.de/auth/realms/RemoteSignature");
        preferences.put(PREF_KEYMANAGERURL, "https://eid.bnotk.de/KeyManager");
        preferences.put(PREF_SSAURL, "https://eid.bnotk.de/ServerSigningApplication");
        preferences.put(PREF_SIGNATURE_HASH_ALGORITHM, "SHA-512");
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        this.setIdpUrl(preferences.get(PREF_IDPURL, this.getIdpUrl()));
        this.setKeyManagerUrl(preferences.get(PREF_KEYMANAGERURL, this.getKeyManagerUrl()));
        this.setSsaUrl(preferences.get(PREF_SSAURL, this.getSsaUrl()));
        this.setSignatureHashAlgorithm(preferences.get(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm()));
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        preferences.put(PREF_IDPURL, this.getIdpUrl());
        preferences.put(PREF_KEYMANAGERURL, this.getKeyManagerUrl());
        preferences.put(PREF_SSAURL, this.getSsaUrl());
        preferences.put(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm());
    }

    public void setIdpUrl(String idpUrl) {
        this.idpUrl = idpUrl;
    }

    public void setKeyManagerUrl(String keyManagerUrl) {
        this.keyManagerUrl = keyManagerUrl;
    }

    public void setSignatureHashAlgorithm(String signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }

    public void setSsaUrl(String ssaUrl) {
        this.ssaUrl = ssaUrl;
    }
}

