/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.pronext.app.signature.ProNEXTSignerFactory;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.security.jca.device.DeviceBasedProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.security.Provider;
import java.security.Security;
import java.util.List;

public class ProNEXTDeviceProvider
extends CommonDeviceProvider<ProNEXTDevice> {
    public ProNEXTDeviceProvider() {
        this.setId("pronext");
    }

    protected ProNEXTDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new ProNEXTDevice(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        ProNEXTSignerFactory descriptor = new ProNEXTSignerFactory();
        descriptor.setType(ISigner.class);
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.pronext");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceBasedProvider jcaProvider = new DeviceBasedProvider();
        Security.addProvider((Provider)jcaProvider);
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

