/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonX509Principal;
import de.intarsys.security.device.pronext.client.dto.RemoteSignatureKey;
import de.intarsys.security.device.pronext.client.dto.RemoteSignatureKeyJson;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.tools.lang.LangTools;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProNEXTPrincipal
extends CommonX509Principal {
    private static final String KEYATTR_SIGNATURE_ALGORITHM = "signature-algorithm";
    public static final String ALGORITHM_RSASSAPSS = "RSASSA-PSS";
    private static final Logger Log = LoggerFactory.getLogger(ProNEXTPrincipal.class);
    private RemoteSignatureKeyJson keyDesc;
    private RemoteSignatureKey key;

    public ProNEXTPrincipal(IDevice device, RemoteSignatureKeyJson keyDesc) {
        super(device, null, keyDesc.getId());
        this.keyDesc = keyDesc;
    }

    protected IX509PublicKeyCertificate createCertificate() {
        try {
            IX509PublicKeyCertificate cert = CertificateTools.wrapJavaCert((X509Certificate)this.getKey().getCertificate());
            return cert;
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProNEXTPrincipal)) {
            return false;
        }
        return LangTools.equals((Object)this.getKeyDesc(), (Object)((ProNEXTPrincipal)((Object)obj)).getKeyDesc());
    }

    public ProNEXTDevice getDevice() {
        return (ProNEXTDevice)super.getDevice();
    }

    public RemoteSignatureKey getKey() {
        if (this.key == null) {
            this.key = this.getKeyDesc().toRemoteSignatureKey();
        }
        return this.key;
    }

    public RemoteSignatureKeyJson getKeyDesc() {
        return this.keyDesc;
    }

    public String getKeyId() {
        return this.getKey().getKeyId();
    }

    public String getSignatureAlgorithm() {
        return this.getKeyDesc().getStringAttribute(KEYATTR_SIGNATURE_ALGORITHM, null);
    }

    public int hashCode() {
        return this.getKeyDesc().hashCode();
    }
}

