/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pronext.device;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.pronext.client.dto.RemoteSignatureKeyJson;
import de.intarsys.security.device.pronext.device.AuthenticationContext;
import de.intarsys.security.device.pronext.device.ProNEXTDevice;
import de.intarsys.security.device.pronext.device.ProNEXTPrincipal;
import de.intarsys.tools.collection.FilterIterator;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProNEXTPrincipalStore {
    private static final Logger Log = LoggerFactory.getLogger(ProNEXTPrincipalStore.class);
    private final ProNEXTDevice device;
    private List<ProNEXTPrincipal> principals;
    private AuthenticationContext authenticationContext;

    public ProNEXTPrincipalStore(ProNEXTDevice device, AuthenticationContext authenticationContext) {
        this.device = device;
        this.authenticationContext = authenticationContext;
    }

    protected List<ProNEXTPrincipal> ensurePrincipalsAvailable() {
        if (this.principals != null) {
            return this.principals;
        }
        try {
            this.getAuthenticationContext().ensureAuthenticated();
            List<RemoteSignatureKeyJson> remoteKeys = this.getDevice().getKeyManagerClient().listKeys(this.getAuthenticationContext().getToken());
            this.principals = remoteKeys.stream().map(k -> new ProNEXTPrincipal((IDevice)this.getDevice(), (RemoteSignatureKeyJson)k)).collect(Collectors.toList());
        }
        catch (SecurityApplicationException | IOException e) {
            Log.warn("Error looking up remote keys: {}", (Object)e.getMessage(), (Object)e);
            this.principals = Collections.emptyList();
        }
        return this.principals;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public ProNEXTDevice getDevice() {
        return this.device;
    }

    protected List<ProNEXTPrincipal> getPrincipals() {
        this.ensurePrincipalsAvailable();
        return this.principals;
    }

    public Iterator<ProNEXTPrincipal> lookupPrincipals(final IPrincipalFilter filter) {
        List<ProNEXTPrincipal> principals = this.getPrincipals();
        return new FilterIterator<ProNEXTPrincipal>(principals.iterator()){

            protected boolean accept(ProNEXTPrincipal principal) {
                return filter.accept((IPrincipal)principal);
            }
        };
    }
}

