/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.activity;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.deepsign.activity.util.QrCodeTools;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.security.device.deepsign.device.DeepSignDevice;
import de.intarsys.security.device.deepsign.dto.DidIdentityIdRequest;
import de.intarsys.security.device.deepsign.dto.DidIdentityIdResponse;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.Requester;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;

public class DeepSignEnrollmentActivity<P extends IActivity<?>>
extends Requester<IPrincipal, P> {
    private final IMessageBundle Messages = MessageTools.getMessageBundle(((Object)((Object)this)).getClass());
    private DeepSignDevice device;

    public DeepSignEnrollmentActivity(P parent) {
        super(parent);
    }

    public static DeepSignEnrollmentActivity<?> create(IActivity<?> parent) {
        DeepSignEnrollmentActivity activity = new DeepSignEnrollmentActivity(parent);
        activity.setModal(true);
        return activity;
    }

    public String getDisplayQrCodeDescription() {
        return this.Messages.getString("DeepSignEnrollmentActivity.displayQrCodeDescription", new Object[0]);
    }

    public String getEnterUsernameDescription() {
        return this.Messages.getString("DeepSignEnrollmentActivity.enterUsernameDescription", new Object[0]);
    }

    public String getErrorDescription() {
        return this.Messages.getString("DeepSignEnrollmentActivity.errorDescription", new Object[0]);
    }

    public String getErrorLabel() {
        return this.Messages.getString("DeepSignEnrollmentActivity.errorLabel", new Object[0]);
    }

    public String getRegisterLabel() {
        return this.Messages.getString("DeepSignEnrollmentActivity.registerLabel", new Object[0]);
    }

    private String receiveRegistrationLink(String username) throws DeepSignSignerException {
        DidIdentityIdResponse didIdentityIdResponse;
        AccessToken accessToken = this.device.authorizeService();
        String accessTokenHeader = accessToken.toAuthorizationHeader();
        DidIdentityIdRequest request = new DidIdentityIdRequest(username);
        WebTarget api = this.device.getClient().target(this.device.getRegisterEndpoint());
        try (Response response = api.request().accept(new String[]{"application/json"}).header("Authorization", (Object)accessTokenHeader).post(Entity.json((Object)request));){
            didIdentityIdResponse = (DidIdentityIdResponse)response.readEntity(DidIdentityIdResponse.class);
        }
        catch (Exception e) {
            throw new DeepSignSignerException(e);
        }
        if (didIdentityIdResponse.registrationDeepLink() != null) {
            return didIdentityIdResponse.registrationDeepLink();
        }
        if (didIdentityIdResponse.personIdentityUid() != null) {
            throw new DeepSignSignerException(this.Messages.getString("DeepSignEnrollmentActivity.alreadyRegistered", new Object[0]));
        }
        throw new DeepSignSignerException(this.Messages.getString("DeepSignEnrollmentActivity.unknownError", new Object[0]));
    }

    public String retrieveQrCodeImageUrl(String username) throws DeepSignSignerException {
        return "data:image/png;base64," + new QrCodeTools().createQrCodeBase64String(this.receiveRegistrationLink(username));
    }

    public void setDevice(DeepSignDevice device) {
        this.device = device;
    }
}

