/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.activity.util;

import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import io.nayuki.qrcodegen.QrCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;

public class QrCodeTools {
    private static BufferedImage toImage(QrCode qr, int scale, int border, int lightColor, int darkColor) {
        Objects.requireNonNull(qr);
        if (scale <= 0 || border < 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        if (border > 0x3FFFFFFF || (long)qr.size + (long)border * 2L > (long)(Integer.MAX_VALUE / scale)) {
            throw new IllegalArgumentException("Scale or border too large");
        }
        int sideLength = (qr.size + border * 2) * scale;
        BufferedImage result = new BufferedImage(sideLength, sideLength, 1);
        for (int y = 0; y < result.getHeight(); ++y) {
            for (int x = 0; x < result.getWidth(); ++x) {
                int adjustedX = x / scale - border;
                int adjustedY = y / scale - border;
                boolean color = qr.getModule(adjustedX, adjustedY);
                result.setRGB(x, y, color ? darkColor : lightColor);
            }
        }
        return result;
    }

    public String createQrCodeBase64String(String registrationLink) throws DeepSignSignerException {
        QrCode qr0 = QrCode.encodeText((CharSequence)registrationLink, (QrCode.Ecc)QrCode.Ecc.MEDIUM);
        BufferedImage img = QrCodeTools.toImage(qr0, 4, 10, 0xFFFFFF, 0);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", outputStream);
        }
        catch (Exception e) {
            throw new DeepSignSignerException(e);
        }
        byte[] imageBytes = outputStream.toByteArray();
        return Base64.getEncoder().encodeToString(imageBytes);
    }
}

