/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.activity.web;

import de.intarsys.security.device.deepsign.activity.DeepSignEnrollmentActivity;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.activity.web.WebActivityHandler;
import de.intarsys.tools.activity.web.WebActivityView;
import de.intarsys.tools.concurrent.IPromise;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepSignEnrollmentActivityHandler
extends WebActivityHandler {
    private static final String PARAM_STATE = "state";
    private static final Logger Log = LoggerFactory.getLogger(DeepSignEnrollmentActivityHandler.class);

    protected void acknowledgeComplete(WebActivityView<?> view) {
        view.getConversation().complete(null);
    }

    protected void acknowledgeCompleteExceptionally(WebActivityView<?> view, Throwable e) {
        view.getConversation().completeExceptionally(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void acknowledgeDisplayQrCode(WebActivityView<?> view, Object value) {
        try {
            IConversation conversation = view.getConversation();
            String personRef = (String)ConverterRegistry.get().convert(value, String.class);
            if (StringTools.isEmpty((String)personRef)) {
                this.startEnterUsername(view);
                return;
            }
            String redirectUri = null;
            HttpRedirectStage replyStage = null;
            DeepSignEnrollmentActivity requester = (DeepSignEnrollmentActivity)view.getActivity();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            try {
                parameters.put("label", requester.getRegisterLabel());
                parameters.put("description", requester.getDisplayQrCodeDescription());
                parameters.put("image", requester.retrieveQrCodeImageUrl(personRef));
                redirectUri = this.getRedirectUri(conversation, this.getUiPageDisplayQrCode());
                replyStage = new HttpRedirectStage(redirectUri, false, true);
                replyStage.onAck(nothing -> this.acknowledgeComplete(view));
            }
            catch (DeepSignSignerException e) {
                try {
                    parameters.put("label", requester.getErrorLabel());
                    parameters.put("description", requester.getErrorDescription() + " " + e.getMessage());
                    redirectUri = this.getRedirectUri(conversation, this.getUiPageDisplayError());
                    replyStage = new HttpRedirectStage(redirectUri, false, true);
                    replyStage.onAck(nothing -> this.acknowledgeCompleteExceptionally(view, (Throwable)((Object)e)));
                }
                catch (Throwable throwable) {
                    conversation.setAttribute((Object)"parameters", parameters);
                    Log.info("{} redirect to {}", (Object)conversation.getHandle(), redirectUri);
                    conversation.setReplyStage(replyStage);
                    throw throwable;
                }
                conversation.setAttribute((Object)"parameters", parameters);
                Log.info("{} redirect to {}", (Object)conversation.getHandle(), (Object)redirectUri);
                conversation.setReplyStage((IReplyStage)replyStage);
                return;
            }
            conversation.setAttribute((Object)"parameters", parameters);
            Log.info("{} redirect to {}", (Object)conversation.getHandle(), (Object)redirectUri);
            conversation.setReplyStage((IReplyStage)replyStage);
            return;
        }
        catch (Exception e) {
            view.getConversation().completeExceptionally((Throwable)e);
        }
    }

    protected Object activityFail(IPromise promise, Throwable t) {
        promise.fail(t);
        return null;
    }

    protected Object activityFinish(IPromise promise, Object value) {
        promise.finish(value);
        return null;
    }

    protected <R> IActivityView basicActivityEnter(IActivity<R> activity) {
        IConversation<R> conversation = this.createConversation();
        conversation.thenAccept(value -> this.activityFinish((IPromise)activity, value)).exceptionally(ex -> {
            this.activityFail((IPromise)activity, (Throwable)ex);
            return null;
        });
        WebActivityView view = new WebActivityView(activity, conversation);
        try {
            this.startEnterUsername(view);
        }
        catch (Exception e) {
            conversation.completeExceptionally((Throwable)e);
        }
        return view;
    }

    protected String getUiPageDisplayError() {
        return "deepSignDisplayError.html";
    }

    private String getRedirectUri(IConversation<?> conversation, String uiPage) {
        return RequestContext.get().getUriBuilderContext().path(this.getUiPath()).path(uiPage).queryParam(PARAM_STATE, new Object[]{conversation.getHandle()}).toString();
    }

    protected <R> IConversation<R> createConversation() {
        return new Conversation("request-" + ((Object)((Object)this)).toString());
    }

    protected String getUiPageDisplayQrCode() {
        return "deepSignDisplayQrCode.html";
    }

    protected String getUiPageEnterUsername() {
        return "deepSignEnterUsername.html";
    }

    private void startEnterUsername(WebActivityView<?> view) {
        DeepSignEnrollmentActivity requester = (DeepSignEnrollmentActivity)view.getActivity();
        IConversation conversation = view.getConversation();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("label", requester.getRegisterLabel());
        parameters.put("description", requester.getEnterUsernameDescription());
        conversation.setAttribute((Object)"parameters", parameters);
        String redirectUri = this.getRedirectUri(conversation, this.getUiPageEnterUsername());
        Log.info("{} redirect to {}", (Object)conversation.getHandle(), (Object)redirectUri);
        HttpRedirectStage replyStage = new HttpRedirectStage(redirectUri, false, true);
        conversation.setReplyStage((IReplyStage)replyStage);
        ConversationRegistry.publishForLifetime((IConversation)conversation);
        replyStage.onAck(username -> this.acknowledgeDisplayQrCode(view, username));
    }

    protected String getUiPath() {
        return "html";
    }
}

