/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.app.signature;

import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.app.signature.SignatureEvidence;
import de.intarsys.security.app.signature.SignatureItemEvidence;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.security.device.deepsign.device.DeepSignDevice;
import de.intarsys.security.device.deepsign.dto.ErrorResponse;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public abstract class DeepSignAbstractSigner
extends CommonBatchSigner {
    private final IMessageBundle Messages = MessageTools.getMessageBundle(((Object)((Object)this)).getClass());

    protected DeepSignAbstractSigner(DeepSignDevice device) {
        super((CommonDevice)device);
        this.setApproximatedContainerSize(Short.MAX_VALUE);
    }

    protected List<SignatureTask> createTaskNames(List<SignatureTask> tempTasks) {
        SignatureEvidence sigantureEvidence = this.getSignatureEvidence();
        Iterator iItemEvidence = null;
        if (sigantureEvidence != null) {
            iItemEvidence = this.getSignatureEvidence().getItems().iterator();
        }
        int index = 0;
        for (SignatureTask task : tempTasks) {
            task.name = "Sign_Live_Document_" + index;
            if (sigantureEvidence != null && iItemEvidence.hasNext()) {
                SignatureItemEvidence itemEvidence = (SignatureItemEvidence)iItemEvidence.next();
                task.name = itemEvidence.getLabel();
            }
            ++index;
        }
        return tempTasks;
    }

    private <T> List<T> decodeAll(List<byte[]> inputs, Decoder<T> decoder) throws DeepSignSignerException {
        if (inputs == null || inputs.isEmpty()) {
            return List.of();
        }
        ArrayList<T> outputs = new ArrayList<T>();
        for (byte[] bytes : inputs) {
            outputs.add(decoder.decode(bytes));
        }
        return outputs;
    }

    public String getEncryptionAlgorithmName() {
        return null;
    }

    protected List<SignatureTask> getSignatureTasks() throws DeepSignSignerException {
        List tasks = this.getTasks();
        if (tasks.isEmpty()) {
            throw new DeepSignSignerException(this.Messages.getString("DeepSignSigner.noTasks", new Object[0]));
        }
        return this.createTaskNames(tasks);
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return null;
    }

    public boolean isBasic() {
        return false;
    }

    protected void parseResponseForErrorMessageAndThrowException(Response response) throws DeepSignSignerException {
        ErrorResponse errorResponse;
        try {
            errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
        }
        catch (ProcessingException | IllegalStateException e) {
            throw new DeepSignSignerException(e);
        }
        throw new DeepSignSignerException(this.Messages.getString("DeepSignSigner.unsuccessfullResponseWithMessage", new Object[0]) + errorResponse.message());
    }

    protected IExtendedValidationData toExtendedValidationData(List<byte[]> crlsList, List<byte[]> ocspsList) throws DeepSignSignerException {
        final List<IX509CRL> crls = this.decodeAll(crlsList, bytes -> {
            IX509CRL iX509CRL;
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            try {
                iX509CRL = X509CertificateFactory.get().createCRL((InputStream)input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CRLException e) {
                    throw new DeepSignSignerException(this.Messages.getString("DeepSignSigner.invalidCRLs", new Object[0]), e);
                }
            }
            input.close();
            return iX509CRL;
        });
        final List<IOCSPResponse> ocspResponses = this.decodeAll(ocspsList, bytes -> {
            try {
                byte[] encodedBasicOcspResponse = org.bouncycastle.asn1.ocsp.OCSPResponse.getInstance((Object)bytes).getResponseBytes().getResponse().getOctets();
                return new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)encodedBasicOcspResponse)));
            }
            catch (RuntimeException e) {
                throw new DeepSignSignerException(this.Messages.getString("DeepSignSigner.invalidOCSPs", new Object[0]), e);
            }
        });
        return new IExtendedValidationData(){

            public Stream<IX509PublicKeyCertificate> getCertificates() {
                return Stream.empty();
            }

            public Stream<IX509CRL> getCRLs() {
                return crls.stream();
            }

            public Stream<IOCSPResponse> getOCSPResponses() {
                return ocspResponses.stream();
            }
        };
    }

    private static interface Decoder<T> {
        public T decode(byte[] var1) throws DeepSignSignerException;
    }
}

