/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.app.signature;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.deepsign.app.signature.DeepSignAbstractSigner;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.security.device.deepsign.device.DeepSignDevice;
import de.intarsys.security.device.deepsign.dto.Hash;
import de.intarsys.security.device.deepsign.dto.SealHashRequest;
import de.intarsys.security.device.deepsign.dto.SealHashResponse;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeepSignSealer
extends DeepSignAbstractSigner {
    private final IMessageBundle Messages = MessageTools.getMessageBundle(((Object)((Object)this)).getClass());
    private AccessToken accessToken;
    private URI apiBaseUri;
    private String sealId;
    private Client client;
    private DeepSignDevice device;

    public DeepSignSealer(DeepSignDevice device, String sealId) {
        super(device);
        this.device = device;
        this.client = device.getClient();
        this.apiBaseUri = device.getapiBaseUri();
        this.sealId = sealId;
    }

    protected IConversation<Void> basicSignAuthorized() {
        try {
            this.accessToken = this.device.authorizeService();
        }
        catch (DeepSignSignerException e) {
            return Conversation.failed((Throwable)((Object)new DeepSignSignerException(this.Messages.getString("DeepSignSigner.exceptionObtainAccessToken", new Object[0]), (Throwable)((Object)e))));
        }
        List<ISignatureData> signatures = null;
        try {
            signatures = this.seal();
        }
        catch (DeepSignSignerException e) {
            return Conversation.failed((Throwable)((Object)e));
        }
        try {
            this.tasksComplete(signatures);
        }
        catch (SecurityApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
        return Conversation.completed(null);
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return null;
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return null;
    }

    private List<SealHashResponse> invokeSealHash() throws DeepSignSignerException {
        String accessTokenHeader = this.accessToken.toAuthorizationHeader();
        List<SignatureTask> signatureTasks = this.getSignatureTasks();
        ArrayList<SealHashResponse> responseList = new ArrayList<SealHashResponse>();
        for (SignatureTask signatureTask : signatureTasks) {
            ArrayList<Hash> hashDigest = new ArrayList<Hash>();
            hashDigest.add(new Hash("document", signatureTask.toBeSignedData.getDigest().getBytes(), signatureTask.toBeSignedData.getDigest().getAlgorithmName()));
            SealHashRequest request = new SealHashRequest(hashDigest, this.sealId);
            URI sealEndpoint = this.apiBaseUri.resolve("seal");
            WebTarget api = this.client.target(sealEndpoint);
            try {
                Response response = api.request().accept(new String[]{"application/json"}).header("Authorization", (Object)accessTokenHeader).post(Entity.json((Object)request));
                try {
                    if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                        responseList.add((SealHashResponse)response.readEntity(SealHashResponse.class));
                        continue;
                    }
                    this.parseResponseForErrorMessageAndThrowException(response);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (Exception e) {
                throw new DeepSignSignerException(e);
            }
        }
        return responseList;
    }

    @Override
    public boolean isBasic() {
        return false;
    }

    private List<ISignatureData> seal() throws DeepSignSignerException {
        List<SealHashResponse> responseList = this.invokeSealHash();
        ArrayList<ISignatureData> result = new ArrayList<ISignatureData>();
        for (SealHashResponse response : responseList) {
            de.intarsys.security.device.deepsign.dto.SignatureData signatureData = response.signatureData();
            byte[] encodedSignature = signatureData.signatures().get(0).signature();
            IExtendedValidationData validationData = this.toExtendedValidationData(signatureData.crls(), signatureData.ocsps());
            ISignatureData resultItem = this.getSignatureOptions().getValidationDataOptions().isAddValidationData() ? ExtendedSignatureData.create((byte[])encodedSignature, null, (IExtendedValidationData)validationData) : SignatureData.create((byte[])encodedSignature);
            result.add(resultItem);
        }
        return result;
    }
}

