/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.app.signature;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.deepsign.app.signature.DeepSignAbstractSigner;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.security.device.deepsign.device.DeepSignDevice;
import de.intarsys.security.device.deepsign.dto.DidIdentityIdRequest;
import de.intarsys.security.device.deepsign.dto.DidIdentityIdResponse;
import de.intarsys.security.device.deepsign.dto.Hash;
import de.intarsys.security.device.deepsign.dto.SignHashRequest;
import de.intarsys.security.device.deepsign.dto.SignHashResponse;
import de.intarsys.security.signature.common.ExtendedSignatureData;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.zones.Zone;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class DeepSignSigner
extends DeepSignAbstractSigner {
    private final IMessageBundle Messages = MessageTools.getMessageBundle(((Object)((Object)this)).getClass());
    private AccessToken accessToken;
    private URI apiBaseUri;
    private URI registerEndpoint;
    private Client client;
    private DeepSignDevice device;
    private String username;
    private String signatureMode;
    private String jurisdiction;
    private String authorityService;
    private String didIdentityId;
    private Conversation<?> conversation;
    private List<String> hashKeyList;

    public DeepSignSigner(DeepSignDevice device, String username, String signatureMode, String jurisdiction, String authorityService, String didIdentityId) {
        super(device);
        this.device = device;
        this.client = device.getClient();
        this.apiBaseUri = device.getapiBaseUri();
        this.registerEndpoint = device.getRegisterEndpoint();
        this.username = username;
        this.signatureMode = signatureMode;
        this.jurisdiction = jurisdiction;
        this.authorityService = authorityService;
        this.didIdentityId = didIdentityId;
    }

    protected IConversation<?> basicSignAuthorized() {
        this.setConversation(new Conversation("deepSignSigner"));
        try {
            this.accessToken = this.device.authorizeService();
        }
        catch (DeepSignSignerException e) {
            this.getConversation().completeExceptionally((Throwable)((Object)new DeepSignSignerException(this.Messages.getString("DeepSignSigner.exceptionObtainAccessToken", new Object[0]), (Throwable)((Object)e))));
            return this.getConversation();
        }
        if (this.didIdentityId == null || this.didIdentityId.isEmpty()) {
            try {
                this.didIdentityId = this.retrieveDidIdentityId(this.username, this.device);
            }
            catch (DeepSignSignerException e) {
                return this.getConversationAndCompleteExceptionally((Throwable)((Object)e));
            }
        }
        try {
            this.hashKeyList = new ArrayList<String>(this.invokeSignAndGetHashKeyList());
        }
        catch (DeepSignSignerException e) {
            return this.getConversationAndCompleteExceptionally((Throwable)((Object)e));
        }
        try {
            this.updateState(this.retrievePendingSignatureResponses());
        }
        catch (SecurityApplicationException e) {
            return this.getConversationAndCompleteExceptionally(e);
        }
        return this.getConversation();
    }

    private List<ISignatureData> extractSignatures(List<SignHashResponse> signatureResponses) throws DeepSignSignerException {
        ArrayList<ISignatureData> result = new ArrayList<ISignatureData>();
        for (SignHashResponse signHashResponse : signatureResponses) {
            de.intarsys.security.device.deepsign.dto.SignatureData signatureData = signHashResponse.signatureData();
            byte[] encodedSignature = signatureData.signatures().get(0).signature();
            IExtendedValidationData validationData = this.toExtendedValidationData(signatureData.crls(), signatureData.ocsps());
            ISignatureData resultItem = this.getSignatureOptions().getValidationDataOptions().isAddValidationData() ? ExtendedSignatureData.create((byte[])encodedSignature, null, (IExtendedValidationData)validationData) : SignatureData.create((byte[])encodedSignature);
            result.add(resultItem);
        }
        return result;
    }

    protected Conversation<?> getConversation() {
        return this.conversation;
    }

    protected Conversation<?> getConversationAndCompleteExceptionally(Throwable e) {
        this.getConversation().completeExceptionally(e);
        return this.conversation;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return null;
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return null;
    }

    private List<String> invokeSignAndGetHashKeyList() throws DeepSignSignerException {
        ArrayList<String> hashKeyList = new ArrayList<String>();
        String accessTokenHeader = this.accessToken.toAuthorizationHeader();
        List<SignatureTask> signatureTasks = this.getSignatureTasks();
        for (SignatureTask signatureTask : signatureTasks) {
            ArrayList<Hash> hashDigest = new ArrayList<Hash>();
            hashDigest.add(new Hash("document", signatureTask.toBeSignedData.getDigest().getBytes(), signatureTask.toBeSignedData.getDigest().getAlgorithmName()));
            SignHashRequest request = new SignHashRequest(hashDigest, null, this.signatureMode, this.jurisdiction, this.authorityService, null, null, this.didIdentityId, signatureTask.name);
            URI signEndpoint = this.apiBaseUri.resolve("sign");
            WebTarget api = this.client.target(signEndpoint);
            try {
                Response response = api.request().accept(new String[]{"application/json"}).header("Authorization", (Object)accessTokenHeader).post(Entity.json((Object)request));
                try {
                    if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                        SignHashResponse.Accepted signHashResponse = (SignHashResponse.Accepted)response.readEntity(SignHashResponse.Accepted.class);
                        hashKeyList.add(signHashResponse.hashKey());
                        continue;
                    }
                    this.parseResponseForErrorMessageAndThrowException(response);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (Exception e) {
                throw new DeepSignSignerException(e);
            }
        }
        return hashKeyList;
    }

    @Override
    public boolean isBasic() {
        return false;
    }

    private List<SignHashResponse> retrievePendingSignatureResponses() throws DeepSignSignerException {
        String accessTokenHeader = this.accessToken.toAuthorizationHeader();
        ArrayList<SignHashResponse> signatureResponseList = new ArrayList<SignHashResponse>();
        for (String hashKey : this.hashKeyList) {
            Response hashKeyResponse = null;
            SignHashResponse signHashResponse = null;
            WebTarget hashKeyApi = this.client.target(this.apiBaseUri.resolve(hashKey + "/status"));
            hashKeyResponse = hashKeyApi.request().accept(new String[]{"application/json"}).header("Authorization", (Object)accessTokenHeader).get();
            if (hashKeyResponse.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                signHashResponse = (SignHashResponse)hashKeyResponse.readEntity(SignHashResponse.class);
            } else {
                this.parseResponseForErrorMessageAndThrowException(hashKeyResponse);
            }
            signatureResponseList.add(signHashResponse);
        }
        return signatureResponseList;
    }

    protected void setConversation(Conversation<?> conversation) {
        this.conversation = conversation;
    }

    private String retrieveDidIdentityId(String personRef, DeepSignDevice device) throws DeepSignSignerException {
        DidIdentityIdResponse didIdentityIdResponse;
        String accessTokenHeader = this.accessToken.toAuthorizationHeader();
        DidIdentityIdRequest request = new DidIdentityIdRequest(personRef);
        WebTarget api = device.getClient().target(this.registerEndpoint);
        try (Response response = api.request().accept(new String[]{"application/json"}).header("Authorization", (Object)accessTokenHeader).post(Entity.json((Object)request));){
            didIdentityIdResponse = (DidIdentityIdResponse)response.readEntity(DidIdentityIdResponse.class);
        }
        catch (Exception e) {
            throw new DeepSignSignerException(e);
        }
        if (didIdentityIdResponse.personIdentityUid() != null) {
            return didIdentityIdResponse.personIdentityUid();
        }
        throw new DeepSignSignerException(this.Messages.getString("DeepSignSigner.userDidIdentityIdNotRegistered", new Object[]{this.username}));
    }

    private void updateState(List<SignHashResponse> signatureResponses) throws SecurityApplicationException {
        boolean isAnyRejected = signatureResponses.stream().anyMatch(response -> "rejected".equals(response.signStatus()));
        boolean isAnyNotSigned = signatureResponses.stream().anyMatch(response -> !"signed".equals(response.signStatus()));
        if (isAnyRejected) {
            this.getConversation().completeExceptionally((Throwable)((Object)new DeepSignSignerException(this.Messages.getString("DeepSignSigner.signatureRejected", new Object[0]))));
            return;
        }
        if (isAnyNotSigned) {
            this.updateStateToProcessing();
            return;
        }
        this.tasksComplete(this.extractSignatures(signatureResponses));
        this.getConversation().complete(null);
    }

    private void updateStateToProcessing() {
        ProcessingStage replyStage = new ProcessingStage(this.getProcessingMessageExpanded());
        Consumer ack = Zone.getCurrent().wrap(response -> {
            try {
                this.updateState(this.retrievePendingSignatureResponses());
            }
            catch (SecurityApplicationException e) {
                this.getConversation().completeExceptionally((Throwable)e);
            }
        });
        replyStage.onAck(ack);
        this.getConversation().setReplyStage((IReplyStage)replyStage);
    }
}

