/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.device;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerException;
import de.intarsys.security.device.deepsign.device.DeepSignDeviceProvider;
import de.intarsys.security.device.key.CommonKeyStore;
import de.intarsys.security.device.key.ReadOnlyKeyStore;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.logging.Level;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=DeepSignDeviceProvider.class)
public class DeepSignDevice
extends CommonDevice<DeepSignDeviceProvider> {
    private static final String ARG_SERVICE_ACCOUNT_USERNAME = "serviceAccountUsername";
    private static final String ARG_SERVICE_ACCOUNT_PASSWORD = "serviceAccountPassword";
    private static final String ARG_CLIENT_ID = "clientId";
    private static final String ARG_CLIENT_SECRET = "clientSecret";
    private static final String ARG_TOKEN_ENDPOINT = "tokenEndpoint";
    private static final String ARG_REGISTER_ENDPOINT = "registerEndpoint";
    private static final String ARG_API_BASE_URI = "apiBaseUri";
    private static final Attribute ATTR_PRINCIPAL = new Attribute("principal");
    private static final int REFRESH_TOKEN_LIFETIME = 36000;
    private static final int TOKEN_EXPIRY_BUFFER = 60;
    private static final URI EMPTY_URI = URI.create("");
    private String serviceAccountUsername;
    private Secret serviceAccountPassword;
    private ClientID clientId;
    private Secret clientSecret;
    private URI tokenEndpoint;
    private URI registerEndpoint;
    private URI apiBaseUri;
    private AccessToken accessToken;
    private RefreshToken refreshToken;
    private Instant expiryTimeAccessToken;
    private Instant expiryTimeRefreshToken;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Client client;
    private CommonKeyStore principalStore = new ReadOnlyKeyStore();
    private boolean loaded = false;
    private ICertificateProvider certificateProvider;

    protected DeepSignDevice(DeepSignDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public AccessToken authorizeService() throws DeepSignSignerException {
        TokenResponse response;
        if (this.accessToken != null && Instant.now().isBefore(this.expiryTimeAccessToken)) {
            return this.accessToken;
        }
        ClientID clientID = new ClientID((Identifier)this.clientId);
        ClientSecretBasic clientAuthentication = new ClientSecretBasic(clientID, this.toNimbus(this.clientSecret));
        TokenRequest request = this.refreshToken != null && Instant.now().isBefore(this.expiryTimeRefreshToken) ? new TokenRequest(this.tokenEndpoint, (ClientAuthentication)clientAuthentication, (AuthorizationGrant)new RefreshTokenGrant(this.refreshToken)) : new TokenRequest(this.tokenEndpoint, (ClientAuthentication)clientAuthentication, (AuthorizationGrant)new ResourceOwnerPasswordCredentialsGrant(this.serviceAccountUsername, this.toNimbus(this.serviceAccountPassword)));
        try {
            response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
        }
        catch (ParseException | IOException e) {
            throw new DeepSignSignerException(e);
        }
        if (response.indicatesSuccess()) {
            this.accessToken = response.toSuccessResponse().getTokens().getAccessToken();
            this.refreshToken = response.toSuccessResponse().getTokens().getRefreshToken();
            this.expiryTimeAccessToken = Instant.now().plusSeconds(this.accessToken.getLifetime() - 60L);
            this.expiryTimeRefreshToken = Instant.now().plusSeconds(35940L);
            return this.accessToken;
        }
        throw new DeepSignSignerException(response.toErrorResponse().getErrorObject().getCode());
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.serviceAccountUsername = ArgTools.getString((IArgs)args, (String)ARG_SERVICE_ACCOUNT_USERNAME, null);
        if (this.serviceAccountUsername == null || this.serviceAccountUsername.isEmpty()) {
            throw ExceptionTools.argumentRequired((String)ARG_SERVICE_ACCOUNT_USERNAME);
        }
        this.serviceAccountPassword = ArgTools.getSecretHide((IArgs)args, (String)ARG_SERVICE_ACCOUNT_PASSWORD, null);
        if (this.serviceAccountPassword.isEmpty()) {
            throw ExceptionTools.argumentRequired((String)ARG_SERVICE_ACCOUNT_PASSWORD);
        }
        String clientIdString = ArgTools.getString((IArgs)args, (String)ARG_CLIENT_ID, null);
        if (clientIdString == null || clientIdString.isEmpty()) {
            throw ExceptionTools.argumentRequired((String)ARG_CLIENT_ID);
        }
        this.clientId = new ClientID(clientIdString);
        this.clientSecret = ArgTools.getSecretHide((IArgs)args, (String)ARG_CLIENT_SECRET, null);
        if (this.clientSecret.isEmpty()) {
            throw ExceptionTools.argumentRequired((String)ARG_CLIENT_SECRET);
        }
        this.tokenEndpoint = ArgTools.getUriStrict((IArgs)args, (String)ARG_TOKEN_ENDPOINT, null);
        ArgTools.getUrlStrict((IArgs)args, (String)ARG_TOKEN_ENDPOINT, null);
        if (this.isUndefined(this.tokenEndpoint)) {
            throw ExceptionTools.argumentRequired((String)ARG_TOKEN_ENDPOINT);
        }
        this.registerEndpoint = ArgTools.getUriStrict((IArgs)args, (String)ARG_REGISTER_ENDPOINT, null);
        ArgTools.getUrlStrict((IArgs)args, (String)ARG_REGISTER_ENDPOINT, null);
        if (this.isUndefined(this.registerEndpoint)) {
            throw ExceptionTools.argumentRequired((String)ARG_REGISTER_ENDPOINT);
        }
        this.apiBaseUri = ArgTools.getUriStrict((IArgs)args, (String)ARG_API_BASE_URI, null);
        ArgTools.getUrlStrict((IArgs)args, (String)ARG_API_BASE_URI, null);
        if (this.isUndefined(this.apiBaseUri)) {
            throw ExceptionTools.argumentRequired((String)ARG_API_BASE_URI);
        }
        LoggingFeature logging = new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig().register((Object)logging).register(JacksonJsonProvider.class));
        this.client = clientBuilder.build();
    }

    public URI getapiBaseUri() {
        return this.apiBaseUri;
    }

    public Client getClient() {
        return this.client;
    }

    public URI getRegisterEndpoint() {
        return this.registerEndpoint;
    }

    protected boolean isUndefined(URI uri) {
        return uri == null || uri.equals(EMPTY_URI);
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- serviceAccountUsername: {}", (Object)this.serviceAccountUsername);
        this.logger.info("  +-- serviceAccountPassword: confidential");
        this.logger.info("  +-- clientId: {}", (Object)this.clientId);
        this.logger.info("  +-- clientSecret: confidential");
        this.logger.info("  +-- tokenEndpoint: {}", (Object)this.tokenEndpoint);
        this.logger.info("  +-- apiBaseUri: {}", (Object)this.apiBaseUri);
    }

    private com.nimbusds.oauth2.sdk.auth.Secret toNimbus(Secret secret) throws DeepSignSignerException {
        try {
            return new com.nimbusds.oauth2.sdk.auth.Secret(secret.getString());
        }
        catch (GeneralSecurityException e) {
            throw new DeepSignSignerException(e);
        }
    }
}

