/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.deepsign.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.principal.IPrincipalAdministration;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.deepsign.app.principals.DeepSignPrincipalAdministrationFactory;
import de.intarsys.security.device.deepsign.app.signature.DeepSignSignerFactory;
import de.intarsys.security.device.deepsign.device.DeepSignDevice;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicensePropertyUnit;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class DeepSignDeviceProvider
extends CommonDeviceProvider<DeepSignDevice> {
    public DeepSignDeviceProvider() {
        this.setId("deepsign");
    }

    protected DeepSignDevice basicCreateInstance(IArgs args) {
        return new DeepSignDevice(this, this.getId(args));
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> applications) {
        super.declareApplicationDescriptors(applications);
        Object descriptor = new DeepSignSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setType(ISigner.class);
        descriptor.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        applications.add((IApplicationDescriptor)descriptor);
        descriptor = new DeepSignPrincipalAdministrationFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IPrincipalAdministration.class);
        applications.add((IApplicationDescriptor)descriptor);
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

