/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.io.DirectoryInstrumentStore;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanExtensions {
    private static final Logger Log = LoggerFactory.getLogger(BeanExtensions.class);

    public static void extensionDelete(Object value) {
        try {
            IInstrument provider = BeanExtensions.getProvider();
            InstrumentTools.objectDelete(provider, "de.intarsys.beans", value);
            provider.flush();
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void extensionInsert(Object value) {
        try {
            IInstrument provider = BeanExtensions.getProvider();
            InstrumentTools.objectInsert(provider, "de.intarsys.beans", value);
            provider.flush();
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void extensionUpdate(Object value) {
        try {
            IInstrument provider = BeanExtensions.getProvider();
            InstrumentTools.objectUpdate(provider, "de.intarsys.beans", value);
            provider.flush();
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected static IInstrument getProvider() throws ObjectCreationException, InstrumentRegistryException {
        IInstrument provider = InstrumentTools.lookupOrCreateInstrument(InstrumentRegistry.get(), "de.intarsys.beans", DirectoryInstrumentStore.getLocal());
        return provider;
    }

    private BeanExtensions() {
    }
}

