/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crl.ICRL;
import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crlstore.CRLGroupNode;
import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.IX509CRLNode;
import de.intarsys.security.crlstore.PACKAGE;
import de.intarsys.security.crlstore.X509CRLNode;
import de.intarsys.tools.message.IMessageBundle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CRLContainerNode
extends CRLGroupNode {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private ICRLContainer container;

    public CRLContainerNode(ICRLContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List basicGetChildren() {
        List children;
        List list = children = super.basicGetChildren();
        synchronized (list) {
            this.synchChildren(children);
        }
        return children;
    }

    @Override
    public boolean contains(String name) {
        return this.container.containsName(name);
    }

    @Override
    public IX509CRLNode createCRLNode() {
        String newName = this.createUniqueName(Msg.getString("CRLContainerNode.LabelNewCRL", new Object[0]));
        this.container.createCRL(newName);
        return (IX509CRLNode)this.getChild(newName);
    }

    public ICRLContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean isImmutable() {
        return !this.getContainer().hasPermissionModify();
    }

    @Override
    public boolean mayUpdate() {
        return this.getContainer().hasPermissionUpdate();
    }

    @Override
    public void removeChild(ICRLNode node) {
        ICRL crl = this.getContainer().getCRL(node.getName());
        if (crl != null) {
            this.getContainer().getCRLs().remove(crl);
        }
        super.removeChild(node);
    }

    protected void synchChildren(List children) {
        HashSet<String> containerAliases = new HashSet<String>();
        for (ICRL crl : this.getContainer().getCRLs()) {
            containerAliases.add(crl.getName());
        }
        HashSet<String> storedAliases = new HashSet<String>();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            X509CRLNode child = (X509CRLNode)i.next();
            String name = child.getName();
            if (!this.getContainer().containsName(name)) {
                i.remove();
                continue;
            }
            storedAliases.add(name);
        }
        for (String alias : containerAliases) {
            if (storedAliases.contains(alias)) continue;
            X509CRLNode child = new X509CRLNode(this.container.getCRL(alias));
            child.setParent(this);
            children.add(child);
        }
    }
}

