/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.IX509CRLNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class CRLNodeBase
implements ICRLNode {
    private ICRLNode parent;
    private List children = new ArrayList();
    private String name;

    protected CRLNodeBase() {
    }

    @Override
    public void addChild(ICRLNode node) {
        this.basicGetChildren().add(node);
        node.setParent(this);
    }

    public void addChildren(List children) {
        for (ICRLNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public void removeChild(ICRLNode node) {
        node.setParent(null);
        this.basicGetChildren().remove(node);
    }

    public void removeChildren(List children) {
        for (ICRLNode child : children) {
            this.removeChild(child);
        }
    }

    protected List basicGetChildren() {
        return this.children;
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean sort) {
        ArrayList result = new ArrayList(this.basicGetChildren());
        if (sort) {
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ICRLNode n1 = (ICRLNode)o1;
                    ICRLNode n2 = (ICRLNode)o2;
                    String name1 = n1.getName();
                    String name2 = n2.getName();
                    if (name1 == null) {
                        name1 = "";
                    }
                    if (name2 == null) {
                        name2 = "";
                    }
                    name1 = name1.toLowerCase();
                    name2 = name2.toLowerCase();
                    return name1.compareTo(name2);
                }
            });
        }
        return result;
    }

    @Override
    public ICRLNode getChild(String name) {
        for (ICRLNode child : this.basicGetChildren()) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public void setParent(ICRLNode node) {
        this.parent = node;
    }

    @Override
    public ICRLNode getParent() {
        return this.parent;
    }

    @Override
    public int size() {
        return this.basicGetChildren().size();
    }

    @Override
    public void dispose() {
        for (ICRLNode child : new ArrayList(this.basicGetChildren())) {
            child.dispose();
        }
        if (this.getParent() == null) {
            return;
        }
        this.getParent().removeChild(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.getName();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getTip() {
        return this.getName();
    }

    @Override
    public IX509CRLNode createCRLNode() {
        return null;
    }

    @Override
    public String createUniqueName(String baseName) {
        Object newName = baseName;
        int i = 1;
        while (this.contains((String)newName)) {
            newName = baseName + "(" + i + ")";
            ++i;
        }
        return newName;
    }

    public boolean contains(String name) {
        return this.getChild(name) != null;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean mayUpdate() {
        return true;
    }
}

