/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crlstore.CRLGroupLibrary;
import de.intarsys.security.crlstore.CRLGroupNode;
import de.intarsys.security.crlstore.CRLStoreEnvironment;
import de.intarsys.security.crlstore.CRLStoreTools;
import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.ICRLStore;
import de.intarsys.security.crlstore.ICRLStoreListener;
import de.intarsys.security.crlstore.IX509CRLNode;
import java.util.ArrayList;
import java.util.List;

public class CRLStore
implements ICRLStore {
    private List listeners = new ArrayList();

    @Override
    public void addListener(ICRLStoreListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean containsCRL(IX509CRL crl) {
        if (crl == null) {
            return false;
        }
        IX509CRLNode node = CRLStoreTools.findNode(this.getLibrary(), crl);
        return node != null;
    }

    protected ICRLContainer getCRLContainer() {
        return CRLStoreEnvironment.get().getCRLContainer();
    }

    @Override
    public CRLGroupLibrary getLibrary() {
        return CRLStoreEnvironment.get().getCRLLibrary();
    }

    protected CRLGroupNode getLocation(String groupName) {
        CRLGroupLibrary library = this.getLibrary();
        if (library == null) {
            return null;
        }
        if (groupName == null) {
            throw new IllegalArgumentException("parentName must not be null");
        }
        ICRLNode location = library.getChild(groupName);
        if (location == null) {
            location = new CRLGroupNode();
            location.setName(groupName);
            library.addChild(location);
        }
        if (!(location instanceof CRLGroupNode)) {
            throw new IllegalArgumentException("groupName points to a certificate");
        }
        return (CRLGroupNode)location;
    }

    @Override
    public void removeListener(ICRLStoreListener listener) {
        this.listeners.remove(listener);
    }

    protected void save() {
        CRLStoreEnvironment.get().save();
    }

    @Override
    public void triggerDialogClosed() {
        this.save();
        for (ICRLStoreListener listener : this.listeners) {
            listener.dialogClosed();
        }
    }

    @Override
    public void triggerDialogOpened() {
        for (ICRLStoreListener listener : this.listeners) {
            listener.dialogOpened();
        }
    }
}

