/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crl.common.CRLContainer;
import de.intarsys.security.crlstore.CRLContainerNode;
import de.intarsys.security.crlstore.CRLGroupLibrary;
import de.intarsys.security.crlstore.CRLStore;
import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.ICRLStore;
import de.intarsys.security.crlstore.PACKAGE;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.xfs.IXFSNode;
import de.intarsys.tools.xfs.XFSScanner;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class CRLStoreEnvironment
implements IPreferencesSupport {
    private static final CRLStoreEnvironment ACTIVE = new CRLStoreEnvironment();
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(CRLStoreEnvironment.class);
    public static final ILocator CRL_STORE_DIR = new FileLocator(new File(FileEnvironment.get().getDataDir(), "crlStore"));
    private static final ILocator CRL_CONTAINER_FILE = CRL_STORE_DIR.getChild("container.xml");
    public static final String PREF_UPDATE_CRLS = "updateCRLs";
    public static final String XP_CRLS = "de.intarsys.security.crls";
    public static final String XE_CRLDIRECTORY = "crldirectory";
    private IExtensionPointHandler installerCRLs = new ExtensionPointHandlerAdapter(){

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (CRLStoreEnvironment.XE_CRLDIRECTORY.equals(element.getName())) {
                String path = element.attributeValue("path", null);
                String name = element.attributeValue("name", null);
                if (path == null) {
                    return null;
                }
                FileLocator pathLocator = new FileLocator(path);
                if (name == null) {
                    name = pathLocator.getName();
                }
                try {
                    CRLContainer container = CRLContainer.createFromLocator((ILocator)pathLocator);
                    CRLStoreEnvironment.this.addCRLContainer(name, (ICRLContainer)container);
                }
                catch (IOException e) {
                    String msg = e.getMessage();
                    this.log(Log, Level.WARN, extension, element, msg, e);
                }
            } else {
                return super.basicInstallInsert(extension, element);
            }
            return null;
        }
    };
    private CRLGroupLibrary crlLibrary;
    private CRLContainer crlContainer;
    private CRLStore store;
    private IPreferences preferences;

    public static CRLStoreEnvironment get() {
        return ACTIVE;
    }

    public void addCRLContainer(String name, ICRLContainer container) {
        CRLContainerNode node = new CRLContainerNode(container);
        node.setName(name);
        this.getCRLLibrary().addChild(node);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    protected ICRLNode findNode(ICRLContainer container) {
        List children = this.getCRLLibrary().getChildren();
        for (ICRLNode child : children) {
            CRLContainerNode cn;
            if (!(child instanceof CRLContainerNode) || container != (cn = (CRLContainerNode)child).getContainer()) continue;
            return cn;
        }
        return null;
    }

    public ICRLContainer getCRLContainer() {
        if (this.crlContainer == null) {
            this.loadCRLContainer();
        }
        return this.crlContainer;
    }

    public synchronized CRLGroupLibrary getCRLLibrary() {
        if (this.crlLibrary == null) {
            this.crlLibrary = new CRLGroupLibrary();
            this.addCRLContainer("Standard", this.getCRLContainer());
            this.registerExtensionsCRLDirectories();
        }
        return this.crlLibrary;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "com.cabaret.prefs.security.common/crlstore";
    }

    public ICRLNode getStandardNode() {
        return this.findNode(this.getCRLContainer());
    }

    public ICRLStore getStore() {
        return this.store;
    }

    protected void initDefaultCRL(IXFSNode node) throws IOException {
        Log.trace("CRL node {} found", (Object)node);
        String path = node.getPath() + node.getName();
        ClassLoaderResourceLocator locator = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), path);
        ILocator sourceDir = locator.getParent();
        ILocator targetDir = CRL_STORE_DIR.getChild(sourceDir.getName());
        for (ILocator child : sourceDir.listLocators(null)) {
            LocatorTools.copy((ILocator)child, (ILocator)targetDir.getChild(child.getName()));
        }
    }

    protected void initDefaultCRLs() {
        XFSScanner scanner = new XFSScanner();
        scanner.setClassLoader(this.getClass().getClassLoader());
        scanner.setPattern(".*/crl.xml");
        scanner.setRootPath("crls");
        try {
            scanner.scan(node -> this.initDefaultCRL(node));
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @PostConstruct
    public void install() {
        this.store = new CRLStore();
    }

    public boolean isUpdateCRLs() {
        return this.getPreferences().getBoolean(PREF_UPDATE_CRLS, false);
    }

    protected void loadCRLContainer() {
        if (!CRL_CONTAINER_FILE.exists()) {
            this.initDefaultCRLs();
        }
        try {
            this.crlContainer = CRLContainer.createFromLocator((ILocator)CRL_STORE_DIR);
        }
        catch (IOException e) {
            Log.debug("can't load '" + CRL_STORE_DIR.getPath() + "' (" + e.getMessage() + ")", (Throwable)e);
            Log.info("Creating CRL store directory at '" + CRL_STORE_DIR.getPath());
            this.crlContainer = CRLContainer.createNew((ILocator)CRL_STORE_DIR);
        }
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.putBoolean(PREF_UPDATE_CRLS, true);
    }

    protected void registerExtensionsCRLDirectories() {
        try {
            InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_CRLS, (IExtensionPointHandler)this.installerCRLs);
        }
        catch (InstrumentRegistryException e) {
            Log.warn("error registering extension point 'de.intarsys.security.crls'");
        }
    }

    public void removeCRLContainer(ICRLContainer container) {
        ICRLNode parent;
        ICRLNode target = this.findNode(container);
        if (target != null && (parent = target.getParent()) != null) {
            parent.removeChild(target);
        }
    }

    protected void save() {
        this.saveCRLContainer();
    }

    protected void saveCRLContainer() {
        if (this.crlContainer == null) {
            return;
        }
        try {
            this.crlContainer.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

