/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crlstore.CRLGroupLibrary;
import de.intarsys.security.crlstore.CRLStoreEnvironment;
import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.IX509CRLNode;
import java.util.HashSet;
import java.util.Set;

class CRLStoreTools {
    CRLStoreTools() {
    }

    public static IX509CRLNode findNode(ICRLNode current, IX509CRL crl) {
        if (current instanceof IX509CRLNode) {
            try {
                IX509CRL currentCRL = ((IX509CRLNode)current).getX509CRL();
                if (crl.equals(currentCRL)) {
                    return (IX509CRLNode)current;
                }
            }
            catch (Exception currentCRL) {
                // empty catch block
            }
        }
        for (ICRLNode child : current.getChildren()) {
            IX509CRLNode result = CRLStoreTools.findNode(child, crl);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ICRLContainer getCRLContainer() {
        return CRLStoreEnvironment.get().getCRLContainer();
    }

    public static Set getCRLs(ICRLNode node) {
        HashSet<IX509CRL> result = new HashSet<IX509CRL>();
        if (node instanceof IX509CRLNode) {
            try {
                IX509CRL currentCRL = ((IX509CRLNode)node).getX509CRL();
                result.add(currentCRL);
            }
            catch (Exception currentCRL) {
                // empty catch block
            }
        }
        for (ICRLNode child : node.getChildren()) {
            result.addAll(CRLStoreTools.getCRLs(child));
        }
        return result;
    }

    public static CRLGroupLibrary getLibrary() {
        return CRLStoreEnvironment.get().getCRLLibrary();
    }
}

