/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IUpdateResult;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crlstore.CRLStoreEnvironment;
import de.intarsys.security.crlstore.ICRLNode;
import de.intarsys.security.crlstore.IX509CRLNode;
import de.intarsys.security.crlstore.PACKAGE;
import de.intarsys.security.tools.X500NameTools;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.function.OnError;
import de.intarsys.tools.function.Predicates;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedCRLProvider
implements ICRLProvider,
IOriginProvider<IX509CRL> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(ManagedCRLProvider.class);

    protected Stream<ICRLNode> collectNodes(ICRLNode scope) {
        return Stream.concat(Stream.of(scope), StreamingTools.safeStream(scope.getChildren()).flatMap(this::collectNodes));
    }

    protected String createName(IX509CRLSelector selector) {
        X500Principal issuer;
        String name = null;
        Collection issuers = selector.getIssuers();
        if (issuers != null && issuers.size() > 0 && (name = X500NameTools.getComponentString((X500Principal)(issuer = (X500Principal)issuers.iterator().next()), (ASN1ObjectIdentifier)BCStyle.CN)) == null) {
            name = issuer.toString();
        }
        return name;
    }

    protected IX509CRLNode createNode(IX509CRLSelector selector, String url) {
        String uniqueName;
        String newName;
        ICRLNode parentNode = this.getStandardNode();
        if (parentNode == null) {
            return null;
        }
        IX509CRLNode crlNode = null;
        String selectorName = this.createName(selector);
        if (selectorName != null) {
            crlNode = (IX509CRLNode)this.getStandardNode().getChild(selectorName);
        }
        if (crlNode == null) {
            crlNode = this.getStandardNode().createCRLNode();
            if (selectorName != null) {
                crlNode.setName(selectorName);
            }
        }
        if (crlNode == null) {
            return null;
        }
        crlNode.addURL(url);
        if (this.isUpdateCRLs() && crlNode.canUpdate() && crlNode.mayUpdate()) {
            try {
                this.update(crlNode, true);
                crlNode.adjustName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((newName = crlNode.getName()) == null && selectorName != null && (uniqueName = crlNode.getParent().createUniqueName(selectorName)) != null) {
            crlNode.setName(uniqueName);
        }
        this.save();
        return crlNode;
    }

    protected ICRLNode getLibrary() {
        return CRLStoreEnvironment.get().getCRLLibrary();
    }

    protected IX509CRLNode getMatchingCRLNode(String url, ICRLNode scope) throws IOException {
        if (scope == null) {
            return null;
        }
        return this.collectNodes(scope).filter(node -> node instanceof IX509CRLNode).map(IX509CRLNode.class::cast).filter(node -> node.containsURL(url)).findFirst().orElse(null);
    }

    protected Stream<IX509CRL> getMatchingCRLs(IX509CRLSelector selector, Set targetIssuers, ICRLNode scope) {
        if (scope == null) {
            return Stream.empty();
        }
        return this.collectNodes(scope).filter(node -> node instanceof IX509CRLNode).map(IX509CRLNode.class::cast).filter(node -> this.matchCRL(selector, (IX509CRLNode)node, targetIssuers)).map(OnError.log(node -> node.getX509CRL(), (Logger)Log, () -> null)).filter(Predicates.isNotNull());
    }

    public IOrigin getOrigin(IX509CRL element) {
        return Origin.cache();
    }

    protected ICRLNode getStandardNode() {
        return CRLStoreEnvironment.get().getStandardNode();
    }

    protected IX509CRL getUpdatedCRL(IX509CRLSelector selector, IX509CRLNode node) {
        IX509CRL crl = null;
        try {
            crl = node.getX509CRL();
        }
        catch (IOException e) {
            return null;
        }
        catch (CRLException e) {
            return null;
        }
        if (!(this.isUpdateCRLs() && node.canUpdate() && node.mayUpdate())) {
            return crl;
        }
        if (crl == null) {
            try {
                this.update(node, false);
                crl = node.getX509CRL();
            }
            catch (IOException iOException) {
            }
            catch (CRLException cRLException) {}
        } else if (selector.getDateAndTime() != null && crl.getNextUpdate() != null && selector.getDateAndTime().after(crl.getNextUpdate())) {
            try {
                this.update(node, false);
                crl = node.getX509CRL();
            }
            catch (IOException iOException) {
            }
            catch (CRLException cRLException) {
                // empty catch block
            }
        }
        return crl;
    }

    protected IX509CRL handleURL(IX509CRLSelector selector, String url) throws IOException, CRLException {
        if (url == null) {
            return null;
        }
        IX509CRLNode crlNode = this.getMatchingCRLNode(url, this.getLibrary());
        if (crlNode == null) {
            crlNode = this.createNode(selector, url);
            return crlNode == null ? null : crlNode.getX509CRL();
        }
        return this.getUpdatedCRL(selector, crlNode);
    }

    protected boolean isUpdateCRLs() {
        return CRLStoreEnvironment.get().isUpdateCRLs();
    }

    public Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        HashSet<X500Principal> targetIssuers = new HashSet<X500Principal>();
        if (selector.getIssuers() != null) {
            targetIssuers.addAll(selector.getIssuers());
        }
        if (selector.getCertificateChecking() != null) {
            targetIssuers.add(selector.getCertificateChecking().getIssuerX500Principal());
        }
        Stream<IX509CRL> result = this.getMatchingCRLs(selector, targetIssuers, this.getLibrary());
        result = StreamingTools.concatIfEmpty(result, () -> {
            try {
                IX509CRL crl = this.handleURL(selector, url);
                if (crl != null) {
                    return Stream.of(crl);
                }
            }
            catch (IOException | CRLException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
            return Stream.empty();
        });
        result = result.peek(CrlTools.attachProvider((ICRLProvider)this));
        return result;
    }

    protected boolean matchCRL(IX509CRLSelector selector, IX509CRLNode node, Set targetIssuers) {
        X500Principal[] issuers = node.getIssuers();
        if (issuers == null) {
            return false;
        }
        boolean acceptIssuer = false;
        for (int i = 0; i < issuers.length; ++i) {
            X500Principal issuer = issuers[i];
            if (!targetIssuers.contains(issuer)) continue;
            acceptIssuer = true;
            break;
        }
        if (!acceptIssuer) {
            return false;
        }
        return this.getUpdatedCRL(selector, node) != null;
    }

    protected void save() {
        CRLStoreEnvironment.get().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(IX509CRLNode node, boolean force) throws IOException {
        IProgressMonitor monitor = Reporter.get().reportActivityStart(Msg.getMessage("ManagedCRLProvider.ActivityUpdatingCRL", new Object[]{node.getName()}), 2);
        try {
            IUpdateResult result = node.update(force);
            if (!result.isSuccessful()) {
                Log.warn(node.getName() + ":" + result.getErrorMessage());
            }
        }
        finally {
            monitor.end();
        }
    }
}

