/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crlstore;

import de.intarsys.security.crl.ICRL;
import de.intarsys.security.crl.ICRLContainer;
import de.intarsys.security.crl.IRemoteAccessInfo;
import de.intarsys.security.crl.IUpdateResult;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.remote.RemoteAccessTools;
import de.intarsys.security.crlstore.CRLContainerNode;
import de.intarsys.security.crlstore.CRLNodeBase;
import de.intarsys.security.crlstore.IX509CRLNode;
import de.intarsys.security.tools.X500NameTools;
import de.intarsys.tools.date.DateEnvironment;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class X509CRLNode
extends CRLNodeBase
implements IX509CRLNode {
    private final ICRL crl;
    private IUpdateResult lastUpdateResult;

    public X509CRLNode(ICRL crl) {
        this.crl = crl;
    }

    @Override
    public void addURL(String url) {
        IRemoteAccessInfo accessInfo = RemoteAccessTools.createAccessInfo((String)url);
        if (accessInfo == null) {
            return;
        }
        this.getCrl().getAccessInfos().add(accessInfo);
    }

    @Override
    public void adjustName() {
        IX509CRL crl = null;
        try {
            crl = this.getX509CRL();
        }
        catch (CRLException cRLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (crl == null) {
            return;
        }
        X500Principal issuer = crl.getIssuerX500Principal();
        if (issuer == null) {
            return;
        }
        String name = X500NameTools.getComponentString((X500Principal)issuer, (ASN1ObjectIdentifier)BCStyle.CN);
        if (name == null) {
            name = issuer.toString();
        }
        if (name == null) {
            return;
        }
        name = this.getParent().createUniqueName(name);
        this.setName(name);
    }

    @Override
    public boolean canUpdate() {
        if (this.getCrl() == null) {
            return false;
        }
        List accessInfos = this.getCrl().getAccessInfos();
        return accessInfos != null && accessInfos.size() != 0;
    }

    @Override
    public boolean containsURL(String url) {
        List accessInfos = this.getCrl().getAccessInfos();
        for (IRemoteAccessInfo accessInfo : accessInfos) {
            String current = RemoteAccessTools.getUrl((IRemoteAccessInfo)accessInfo);
            if (!current.equals(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.getContainer().removeCRL(this.getCrl());
        super.dispose();
    }

    protected ICRLContainer getContainer() {
        CRLContainerNode parent = (CRLContainerNode)this.getParent();
        return parent.getContainer();
    }

    public ICRL getCrl() {
        return this.crl;
    }

    @Override
    public Date getExpiryDate() {
        try {
            Date thisUpdate;
            if (this.getX509CRL() == null) {
                return null;
            }
            Date nextUpdate = this.getX509CRL().getNextUpdate();
            if (nextUpdate == null && (thisUpdate = this.getX509CRL().getThisUpdate()) != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(thisUpdate);
                cal.add(5, 1);
                nextUpdate = cal.getTime();
            }
            return nextUpdate;
        }
        catch (CRLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getIconName() {
        try {
            if (!this.testCrl()) {
                return "icons/warning";
            }
        }
        catch (CRLException e) {
            return "icons/error";
        }
        catch (IOException e) {
            return "icons/error";
        }
        if (this.isOutdated()) {
            return "icons/warning";
        }
        return "icons/showall";
    }

    @Override
    public X500Principal[] getIssuers() {
        return this.getCrl().getIssuers();
    }

    @Override
    public String getName() {
        return this.getCrl().getName();
    }

    @Override
    public IX509CRL getX509CRL() throws IOException, CRLException {
        return this.getCrl().getX509CRL();
    }

    @Override
    public boolean isImmutable() {
        return this.getParent().isImmutable();
    }

    @Override
    public boolean isOutdated() {
        Date nextUpdate = this.getExpiryDate();
        if (nextUpdate == null) {
            return true;
        }
        return nextUpdate.before(DateEnvironment.get().now());
    }

    @Override
    public boolean mayUpdate() {
        return this.getParent().mayUpdate();
    }

    @Override
    public void setName(String name) {
        this.getCrl().setName(name);
    }

    protected boolean testCrl() throws IOException, CRLException {
        if (this.getCrl() == null) {
            return false;
        }
        return this.getX509CRL() != null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IUpdateResult update(boolean force) {
        IUpdateResult result;
        if (!force && this.lastUpdateResult != null && !this.lastUpdateResult.isSuccessful() && System.currentTimeMillis() - this.lastUpdateResult.getTime().getTime() < 3600000L) {
            return this.lastUpdateResult;
        }
        this.lastUpdateResult = result = this.getCrl().update();
        return this.lastUpdateResult;
    }
}

