/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.azure.app;

import com.azure.core.exception.ResourceNotFoundException;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyCurveName;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.azure.app.RsaSignatureScheme;
import de.intarsys.security.device.azure.device.AzureDevice;
import de.intarsys.security.device.azure.device.AzurePrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class AzureSigner
extends CommonSingleSigner {
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Collections.unmodifiableList(Arrays.asList("SHA-256", "SHA-384", "SHA-512"));
    private CryptographyClient cryptoClient;
    private AzurePrincipal principal;
    private RsaSignatureScheme rsaSignatureScheme;
    private Collection<String> supportedHashAlgorithmNames = SUPPORTED_DIGEST_ALGORITHMS;
    private AzureSignerImpl signerImpl;

    public AzureSigner(AzureDevice device, AzurePrincipal principal) {
        super((CommonDevice)device);
        this.setPrincipal(principal);
    }

    protected void basicDispose() {
        super.basicDispose();
        this.cryptoClient = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        byte[] signatureValue;
        try {
            IDigest digest = data.getDigest();
            this.checkDigestAlgorithm(digest.getAlgorithmName());
            this.signerImpl = this.deriveSignerImpl(digest.getAlgorithmName());
            signatureValue = this.signerImpl.sign(digest);
        }
        catch (ResourceNotFoundException | UnsupportedOperationException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException(e));
        }
        catch (SecurityApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
        return Conversation.completed((Object)SignatureData.create((byte[])signatureValue));
    }

    public void buildCertificatePath() {
        try {
            this.setCertificatePath(this.getPrincipal().getCertificatePath());
        }
        catch (SecurityApplicationException securityApplicationException) {
            // empty catch block
        }
    }

    protected void checkDigestAlgorithm(String algorithmName) throws SecurityApplicationException {
        if (!this.getSupportedHashAlgorithmNames().contains(algorithmName)) {
            throw new SecurityApplicationException("Hash algorithm" + algorithmName + " not supported by signing key");
        }
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    protected AzureSignerImpl deriveSignerImpl(String digestAlgorithmName) {
        if (PpkTools.isSignatureAlgorithmECDSA((String)this.getPrincipal().getX509PublicKeyCertificate().getPublicKey().getAlgorithm())) {
            return new EcdsaSignerImpl(digestAlgorithmName);
        }
        RsaSignatureScheme rsaSignatureScheme = this.getRsaSignatureScheme();
        switch (rsaSignatureScheme) {
            case PKCSv1_5: {
                return new RsaPkcs1SignerImpl(digestAlgorithmName);
            }
            case PSS: {
                return new RsaPssSignerImpl(digestAlgorithmName);
            }
        }
        throw new IllegalArgumentException("Unsupported RSA signature scheme: " + rsaSignatureScheme);
    }

    protected Collection<String> determineSupportedHashAlgorithmNames(AzurePrincipal principal, CryptographyClient cryptographyClient) {
        if (PpkTools.isSignatureAlgorithmECDSA((String)principal.getX509PublicKeyCertificate().getPublicKey().getAlgorithm())) {
            KeyCurveName curveName = Optional.ofNullable(cryptographyClient.getKey()).map(KeyVaultKey::getKey).map(JsonWebKey::getCurveName).orElse(null);
            if (KeyCurveName.P_256.equals((Object)curveName) || KeyCurveName.P_256K.equals((Object)curveName)) {
                return ListTools.with((Object[])new String[]{"SHA-256"});
            }
            if (KeyCurveName.P_384.equals((Object)curveName)) {
                return ListTools.with((Object[])new String[]{"SHA-384"});
            }
            if (KeyCurveName.P_521.equals((Object)curveName)) {
                return ListTools.with((Object[])new String[]{"SHA-512"});
            }
        }
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        if (this.signerImpl == null) {
            return null;
        }
        return this.signerImpl.getAlgorithmParameterSpec();
    }

    protected CryptographyClient getCryptoClient() {
        return this.cryptoClient;
    }

    public AzureDevice getDevice() {
        return (AzureDevice)super.getDevice();
    }

    public String getEncryptionAlgorithmName() {
        return this.getCertificate().getPublicKey().getAlgorithm();
    }

    public String getLabel() {
        return "Azure signer";
    }

    public AzurePrincipal getPrincipal() {
        return this.principal;
    }

    public RsaSignatureScheme getRsaSignatureScheme() {
        return this.rsaSignatureScheme;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return this.supportedHashAlgorithmNames;
    }

    public void init() {
        super.init();
        this.cryptoClient = this.getDevice().getCryptographyClient(this.getPrincipal().getCertificateName());
        this.supportedHashAlgorithmNames = this.determineSupportedHashAlgorithmNames(this.getPrincipal(), this.getCryptoClient());
    }

    public boolean isBasic() {
        return true;
    }

    protected void setPrincipal(AzurePrincipal principal) {
        this.principal = principal;
    }

    public void setRsaSignatureScheme(RsaSignatureScheme scheme) {
        this.rsaSignatureScheme = scheme;
    }

    private abstract class AzureSignerImpl {
        private final String digestAlgorithmName;

        protected AzureSignerImpl(String digestAlgorithmName) {
            this.digestAlgorithmName = digestAlgorithmName;
        }

        public AlgorithmParameterSpec getAlgorithmParameterSpec() {
            return null;
        }

        protected String getDigestAlgorithmName() {
            return this.digestAlgorithmName;
        }

        protected abstract SignatureAlgorithm getSignatureAlgorithm();

        public byte[] sign(IDigest digest) {
            SignResult signResult = AzureSigner.this.getCryptoClient().sign(this.getSignatureAlgorithm(), digest.getBytes());
            return signResult.getSignature();
        }
    }

    private class EcdsaSignerImpl
    extends AzureSignerImpl {
        public EcdsaSignerImpl(String digestAlgorithmName) {
            super(digestAlgorithmName);
        }

        @Override
        protected SignatureAlgorithm getSignatureAlgorithm() {
            switch (this.getDigestAlgorithmName()) {
                case "SHA-256": {
                    return SignatureAlgorithm.ES256;
                }
                case "SHA-384": {
                    return SignatureAlgorithm.ES384;
                }
                case "SHA-512": {
                    return SignatureAlgorithm.ES512;
                }
            }
            throw new IllegalStateException("Unsupported digest algorithm for ECDSA: " + this.getDigestAlgorithmName());
        }

        @Override
        public byte[] sign(IDigest digest) {
            byte[] plain = super.sign(digest);
            return EcdsaTools.encodeDerSigValue((byte[])plain, (PublicKey)AzureSigner.this.getPrincipal().getX509PublicKeyCertificate().getPublicKey());
        }
    }

    private class RsaPkcs1SignerImpl
    extends AzureSignerImpl {
        public RsaPkcs1SignerImpl(String digestAlgorithmName) {
            super(digestAlgorithmName);
        }

        @Override
        protected SignatureAlgorithm getSignatureAlgorithm() {
            switch (this.getDigestAlgorithmName()) {
                case "SHA-256": {
                    return SignatureAlgorithm.RS256;
                }
                case "SHA-384": {
                    return SignatureAlgorithm.RS384;
                }
                case "SHA-512": {
                    return SignatureAlgorithm.RS512;
                }
            }
            throw new IllegalStateException("Unsupported digest algorithm for RSA-PKCS#1v1.5: " + this.getDigestAlgorithmName());
        }
    }

    private class RsaPssSignerImpl
    extends AzureSignerImpl {
        public RsaPssSignerImpl(String digestAlgorithmName) {
            super(digestAlgorithmName);
        }

        @Override
        public AlgorithmParameterSpec getAlgorithmParameterSpec() {
            return PSSEncoding.createPSSParameterSpec((String)this.getDigestAlgorithmName());
        }

        @Override
        protected SignatureAlgorithm getSignatureAlgorithm() {
            switch (this.getDigestAlgorithmName()) {
                case "SHA-256": {
                    return SignatureAlgorithm.PS256;
                }
                case "SHA-384": {
                    return SignatureAlgorithm.PS384;
                }
                case "SHA-512": {
                    return SignatureAlgorithm.PS512;
                }
            }
            throw new IllegalStateException("Unsupported digest algorithm for RSA-PSS: " + this.getDigestAlgorithmName());
        }
    }
}

